/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.simplereport;

import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SimpleReport {
    private final XmlSimpleReport wrapped;

    public SimpleReport(XmlSimpleReport wrapped) {
        this.wrapped = wrapped;
    }

    public Date getValidationTime() {
        return this.wrapped.getValidationTime();
    }

    public Indication getIndication(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getIndication();
        }
        return null;
    }

    public SubIndication getSubIndication(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getSubIndication();
        }
        return null;
    }

    public boolean isSignatureValid(String signatureId) {
        Indication indicationValue = this.getIndication(signatureId);
        return Indication.TOTAL_PASSED.equals(indicationValue);
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        SignatureQualification qualif = SignatureQualification.NA;
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null && signature.getSignatureLevel() != null) {
            qualif = signature.getSignatureLevel().getValue();
        }
        return qualif;
    }

    public List<String> getSignatureIdList() {
        ArrayList<String> signatureIdList = new ArrayList<String>();
        List<XmlSignature> signatures = this.wrapped.getSignature();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                signatureIdList.add(xmlSignature.getId());
            }
        }
        return signatureIdList;
    }

    public String getFirstSignatureId() {
        List<String> signatureIdList = this.getSignatureIdList();
        if (signatureIdList.size() > 0) {
            return signatureIdList.get(0);
        }
        return null;
    }

    public List<String> getInfo(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getInfos();
        }
        return Collections.emptyList();
    }

    public List<String> getErrors(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getErrors();
        }
        return Collections.emptyList();
    }

    public List<String> getWarnings(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getWarnings();
        }
        return Collections.emptyList();
    }

    public SignatureLevel getSignatureFormat(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSignatureFormat();
        }
        return null;
    }

    public Date getSigningTime(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSigningTime();
        }
        return null;
    }

    public String getSignedBy(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSignedBy();
        }
        return "";
    }

    public int getSignaturesCount() {
        return this.wrapped.getSignaturesCount();
    }

    public int getValidSignaturesCount() {
        return this.wrapped.getValidSignaturesCount();
    }

    private XmlSignature getSignatureById(String signatureId) {
        List<XmlSignature> signatures = this.wrapped.getSignature();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                if (!signatureId.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    public XmlSimpleReport getJaxbModel() {
        return this.wrapped;
    }
}

