/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.security.Security;
import java.util.Date;

public abstract class AbstractSignatureService<SP extends AbstractSignatureParameters>
implements DocumentSignatureService<SP> {
    protected TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;

    protected AbstractSignatureService(CertificateVerifier certificateVerifier) {
        if (certificateVerifier == null) {
            throw new NullPointerException("CertificateVerifier cannot be null !");
        }
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void assertSigningDateInCertificateValidityRange(SP parameters) {
        if (((AbstractSerializableSignatureParameters)parameters).isSignWithExpiredCertificate() || ((AbstractSignatureParameters)parameters).getSigningCertificate() == null && ((AbstractSerializableSignatureParameters)parameters).isGenerateTBSWithoutCertificate()) {
            return;
        }
        CertificateToken signingCertificate = ((AbstractSignatureParameters)parameters).getSigningCertificate();
        Date notAfter = signingCertificate.getNotAfter();
        Date notBefore = signingCertificate.getNotBefore();
        Date signingDate = ((AbstractSerializableSignatureParameters)parameters).bLevel().getSigningDate();
        if (signingDate.after(notAfter) || signingDate.before(notBefore)) {
            throw new DSSException(String.format("Signing Date (%s) is not in certificate validity range (%s, %s).", signingDate.toString(), notBefore.toString(), notAfter.toString()));
        }
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level, ASiCContainerType containerType) {
        StringBuilder finalName = new StringBuilder();
        String originalName = null;
        originalName = containerType != null ? "container" : originalFile.getName();
        if (Utils.isStringNotEmpty(originalName)) {
            int dotPosition = originalName.lastIndexOf(46);
            if (dotPosition > 0) {
                finalName.append(originalName.substring(0, dotPosition));
            } else {
                finalName.append(originalName);
            }
        } else {
            finalName.append("document");
        }
        if (SigningOperation.SIGN.equals((Object)operation)) {
            finalName.append("-signed-");
        } else if (SigningOperation.EXTEND.equals((Object)operation)) {
            finalName.append("-extended-");
        }
        finalName.append(Utils.lowerCase(level.name().replaceAll("_", "-")));
        finalName.append('.');
        if (containerType != null) {
            switch (containerType) {
                case ASiC_S: {
                    finalName.append("asics");
                    break;
                }
                case ASiC_E: {
                    finalName.append("asice");
                    break;
                }
            }
        } else {
            SignatureForm signatureForm = level.getSignatureForm();
            switch (signatureForm) {
                case XAdES: {
                    finalName.append("xml");
                    break;
                }
                case CAdES: {
                    finalName.append("pkcs7");
                    break;
                }
                case PAdES: {
                    finalName.append("pdf");
                    break;
                }
            }
        }
        return finalName.toString();
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level) {
        return this.getFinalFileName(originalFile, operation, level, null);
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

