/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.NonceSource;
import eu.europa.esig.dss.service.http.commons.OCSPDataLoader;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.x509.revocation.OnlineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRespStatus;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPTokenBuilder;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPTokenUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineOCSPSource
implements OCSPSource,
RevocationSourceAlternateUrlsSupport<OCSPToken>,
OnlineRevocationSource<OCSPToken> {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineOCSPSource.class);
    private NonceSource nonceSource;
    private DataLoader dataLoader = new OCSPDataLoader();

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setNonceSource(NonceSource nonceSource) {
        this.nonceSource = nonceSource;
    }

    @Override
    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, Collections.emptyList());
    }

    @Override
    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> alternativeUrls) {
        List<String> ocspAccessLocations;
        if (this.dataLoader == null) {
            throw new NullPointerException("DataLoader is not provided !");
        }
        String dssIdAsString = certificateToken.getDSSIdAsString();
        LOG.trace("--> OnlineOCSPSource queried for {}", (Object)dssIdAsString);
        if (Utils.isCollectionNotEmpty(alternativeUrls)) {
            LOG.info("OCSP alternative urls : {}", (Object)alternativeUrls);
        }
        if (Utils.isCollectionEmpty(ocspAccessLocations = DSSASN1Utils.getOCSPAccessLocations(certificateToken)) && Utils.isCollectionEmpty(alternativeUrls)) {
            LOG.debug("No OCSP location found for {}", (Object)dssIdAsString);
            return null;
        }
        ocspAccessLocations.addAll(alternativeUrls);
        CertificateID certId = DSSRevocationUtils.getOCSPCertificateID(certificateToken, issuerCertificateToken);
        BigInteger nonce = null;
        if (this.nonceSource != null) {
            nonce = this.nonceSource.getNonce();
        }
        byte[] content = this.buildOCSPRequest(certId, nonce);
        int nbTries = ocspAccessLocations.size();
        for (String ocspAccessLocation : ocspAccessLocations) {
            --nbTries;
            try {
                byte[] ocspRespBytes = this.dataLoader.post(ocspAccessLocation, content);
                if (Utils.isArrayEmpty(ocspRespBytes)) continue;
                OCSPResp ocspResp = new OCSPResp(ocspRespBytes);
                OCSPRespStatus status = OCSPRespStatus.fromInt(ocspResp.getStatus());
                if (OCSPRespStatus.SUCCESSFUL.equals((Object)status)) {
                    OCSPTokenBuilder ocspTokenBuilder = new OCSPTokenBuilder(ocspResp, certificateToken, issuerCertificateToken);
                    ocspTokenBuilder.setNonce(nonce);
                    ocspTokenBuilder.setSourceURL(ocspAccessLocation);
                    OCSPToken ocspToken = ocspTokenBuilder.build();
                    OCSPTokenUtils.checkTokenValidity(ocspToken, certificateToken, issuerCertificateToken);
                    ocspToken.setOrigins(Collections.singleton(RevocationOrigin.EXTERNAL));
                    return ocspToken;
                }
                LOG.warn("OCSP Response status with URL '{}' : {}", (Object)ocspAccessLocation, (Object)status);
            }
            catch (Exception e) {
                if (nbTries == 0) {
                    throw new DSSException("Unable to retrieve OCSP response", e);
                }
                LOG.warn("Unable to retrieve OCSP response with URL '{}' : {}", (Object)ocspAccessLocation, (Object)e.getMessage());
            }
        }
        return null;
    }

    private byte[] buildOCSPRequest(CertificateID certId, BigInteger nonce) throws DSSException {
        try {
            OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
            ocspReqBuilder.addRequest(certId);
            if (nonce != null) {
                DEROctetString encodedNonceValue = new DEROctetString(new DEROctetString(nonce.toByteArray()).getEncoded());
                Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)encodedNonceValue);
                Extensions extensions = new Extensions(extension);
                ocspReqBuilder.setRequestExtensions(extensions);
            }
            OCSPReq ocspReq = ocspReqBuilder.build();
            byte[] ocspReqData = ocspReq.getEncoded();
            return ocspReqData;
        }
        catch (IOException | OCSPException e) {
            throw new DSSException("Cannot build OCSP Request", e);
        }
    }
}

