/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationException;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheCRLSource
extends JdbcRevocationSource<CRLToken>
implements CRLSource {
    private static final long serialVersionUID = 3007740140330998336L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheCRLSource.class);
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_CRL";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA BLOB, SIGNATURE_ALGORITHM VARCHAR(20), THIS_UPDATE TIMESTAMP, NEXT_UPDATE TIMESTAMP, EXPIRED_CERTS_ON_CRL TIMESTAMP, ISSUER LONGVARBINARY, ISSUER_PRINCIPAL_MATCH BOOLEAN, SIGNATURE_INTACT BOOLEAN, CRL_SIGN_KEY_USAGE BOOLEAN, UNKNOWN_CRITICAL_EXTENSION BOOLEAN, SIGNATURE_INVALID_REASON VARCHAR(256))";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_FIND_QUERY_ID = "ID";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_ISSUER = "ISSUER";
    private static final String SQL_FIND_QUERY_THIS_UPDATE = "THIS_UPDATE";
    private static final String SQL_FIND_QUERY_NEXT_UPDATE = "NEXT_UPDATE";
    private static final String SQL_FIND_QUERY_EXPIRED_CERTS_ON_CRL = "EXPIRED_CERTS_ON_CRL";
    private static final String SQL_FIND_QUERY_SIGNATURE_ALGO = "SIGNATURE_ALGORITHM";
    private static final String SQL_FIND_QUERY_ISSUER_PRINCIPAL_MATCH = "ISSUER_PRINCIPAL_MATCH";
    private static final String SQL_FIND_QUERY_SIGNATURE_INTACT = "SIGNATURE_INTACT";
    private static final String SQL_FIND_QUERY_CRL_SIGN_KEY_USAGE = "CRL_SIGN_KEY_USAGE";
    private static final String SQL_FIND_QUERY_UNKNOWN_CRITICAL_EXTENSION = "UNKNOWN_CRITICAL_EXTENSION";
    private static final String SQL_FIND_QUERY_SIGNATURE_INVALID_REASON = "SIGNATURE_INVALID_REASON";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_CRL (ID, DATA, SIGNATURE_ALGORITHM, THIS_UPDATE, NEXT_UPDATE, EXPIRED_CERTS_ON_CRL, ISSUER, ISSUER_PRINCIPAL_MATCH, SIGNATURE_INTACT, CRL_SIGN_KEY_USAGE, UNKNOWN_CRITICAL_EXTENSION, SIGNATURE_INVALID_REASON) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_CRL SET DATA = ?, SIGNATURE_ALGORITHM = ?, THIS_UPDATE = ?, NEXT_UPDATE = ?, EXPIRED_CERTS_ON_CRL = ?, ISSUER = ?, ISSUER_PRINCIPAL_MATCH = ?, SIGNATURE_INTACT = ?, CRL_SIGN_KEY_USAGE = ?, UNKNOWN_CRITICAL_EXTENSION = ?, SIGNATURE_INVALID_REASON = ?  WHERE ID = ?";
    private static final String SQL_FIND_REMOVE = "DELETE FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE CACHED_CRL";

    @Override
    protected String getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    @Override
    protected String getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    @Override
    protected String getFindRevocationQuery() {
        return SQL_FIND_QUERY;
    }

    @Override
    protected String getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    @Override
    protected String getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    @Override
    public List<String> initRevocationTokenKey(CertificateToken certificateToken) {
        return DSSRevocationUtils.getCRLRevocationTokenKeys(certificateToken);
    }

    @Override
    protected CRLToken buildRevocationTokenFromResult(ResultSet rs, CertificateToken certificateToken, CertificateToken issuerCert) {
        try {
            CRLBinary crlBinaryIdentifier = new CRLBinary(rs.getBytes(SQL_FIND_QUERY_DATA));
            CRLValidity cached = new CRLValidity(crlBinaryIdentifier);
            cached.setKey(rs.getString(SQL_FIND_QUERY_ID));
            cached.setSignatureAlgorithm(SignatureAlgorithm.valueOf(rs.getString(SQL_FIND_QUERY_SIGNATURE_ALGO)));
            cached.setThisUpdate((Date)rs.getTimestamp(SQL_FIND_QUERY_THIS_UPDATE));
            cached.setNextUpdate((Date)rs.getTimestamp(SQL_FIND_QUERY_NEXT_UPDATE));
            cached.setExpiredCertsOnCRL((Date)rs.getTimestamp(SQL_FIND_QUERY_EXPIRED_CERTS_ON_CRL));
            cached.setIssuerToken(DSSUtils.loadCertificate(rs.getBytes(SQL_FIND_QUERY_ISSUER)));
            cached.setCrlSignKeyUsage(rs.getBoolean(SQL_FIND_QUERY_CRL_SIGN_KEY_USAGE));
            cached.setUnknownCriticalExtension(rs.getBoolean(SQL_FIND_QUERY_UNKNOWN_CRITICAL_EXTENSION));
            cached.setIssuerX509PrincipalMatches(rs.getBoolean(SQL_FIND_QUERY_ISSUER_PRINCIPAL_MATCH));
            cached.setSignatureIntact(rs.getBoolean(SQL_FIND_QUERY_SIGNATURE_INTACT));
            cached.setSignatureInvalidityReason(rs.getString(SQL_FIND_QUERY_SIGNATURE_INVALID_REASON));
            CRLToken crlToken = new CRLToken(certificateToken, cached);
            crlToken.setOrigins(Collections.singleton(RevocationOrigin.CACHED));
            return crlToken;
        }
        catch (SQLException e) {
            throw new RevocationException("An error occurred during an attempt to get a revocation token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertRevocation(CRLToken token) {
        Connection c = null;
        PreparedStatement s2 = null;
        CRLValidity crlValidity = token.getCrlValidity();
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(SQL_FIND_INSERT);
            s2.setString(1, token.getRevocationTokenKey());
            s2.setBytes(2, crlValidity.getCrlEncoded());
            s2.setString(3, crlValidity.getSignatureAlgorithm().name());
            if (crlValidity.getThisUpdate() != null) {
                s2.setTimestamp(4, new Timestamp(crlValidity.getThisUpdate().getTime()));
            } else {
                s2.setNull(4, 93);
            }
            if (crlValidity.getNextUpdate() != null) {
                s2.setTimestamp(5, new Timestamp(crlValidity.getNextUpdate().getTime()));
            } else {
                s2.setNull(5, 93);
            }
            if (crlValidity.getExpiredCertsOnCRL() != null) {
                s2.setTimestamp(6, new Timestamp(crlValidity.getExpiredCertsOnCRL().getTime()));
            } else {
                s2.setNull(6, 93);
            }
            s2.setBytes(7, crlValidity.getIssuerToken().getEncoded());
            s2.setBoolean(8, crlValidity.isIssuerX509PrincipalMatches());
            s2.setBoolean(9, crlValidity.isSignatureIntact());
            s2.setBoolean(10, crlValidity.isCrlSignKeyUsage());
            s2.setBoolean(11, crlValidity.isUnknownCriticalExtension());
            s2.setString(12, crlValidity.getSignatureInvalidityReason());
            s2.executeUpdate();
            c.commit();
            LOG.debug("CRL token with key '{}' successfully inserted in DB", (Object)token.getRevocationTokenKey());
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to insert CRL in the DB", e);
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
            this.closeQuietly(c, s2, null);
        }
        this.closeQuietly(c, s2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRevocation(CRLToken token) {
        Connection c = null;
        PreparedStatement s2 = null;
        CRLValidity crlValidity = token.getCrlValidity();
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(SQL_FIND_UPDATE);
            s2.setBytes(1, crlValidity.getCrlEncoded());
            s2.setString(2, crlValidity.getSignatureAlgorithm().name());
            if (crlValidity.getThisUpdate() != null) {
                s2.setTimestamp(3, new Timestamp(crlValidity.getThisUpdate().getTime()));
            } else {
                s2.setNull(3, 93);
            }
            if (crlValidity.getNextUpdate() != null) {
                s2.setTimestamp(4, new Timestamp(crlValidity.getNextUpdate().getTime()));
            } else {
                s2.setNull(4, 93);
            }
            if (crlValidity.getExpiredCertsOnCRL() != null) {
                s2.setTimestamp(5, new Timestamp(crlValidity.getExpiredCertsOnCRL().getTime()));
            } else {
                s2.setNull(5, 93);
            }
            s2.setBytes(6, crlValidity.getIssuerToken().getEncoded());
            s2.setBoolean(7, crlValidity.isIssuerX509PrincipalMatches());
            s2.setBoolean(8, crlValidity.isSignatureIntact());
            s2.setBoolean(9, crlValidity.isCrlSignKeyUsage());
            s2.setBoolean(10, crlValidity.isUnknownCriticalExtension());
            s2.setString(11, crlValidity.getSignatureInvalidityReason());
            s2.setString(12, token.getRevocationTokenKey());
            s2.executeUpdate();
            c.commit();
            LOG.debug("CRL token with key '{}' successfully updated in DB", (Object)token.getRevocationTokenKey());
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to update CRL in the DB", e);
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
            this.closeQuietly(c, s2, null);
        }
        this.closeQuietly(c, s2, null);
    }
}

