/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CommonDrawerUtils {
    private static final int DPI = 300;
    protected static final int PDF_DEFAULT_DPI = 72;

    private CommonDrawerUtils() {
    }

    public static int getTextDpi() {
        return 300;
    }

    public static int getDpi(Integer dpi) {
        int result = 300;
        if (dpi != null && dpi > 0) {
            result = dpi;
        }
        return result;
    }

    public static float toDpiAxisPoint(float x, float dpi) {
        return x * 72.0f / dpi;
    }

    public static float computeProperSize(float x, float dpi) {
        return x * dpi / 72.0f;
    }

    public static float getRation(Integer dpi) {
        float floatDpi = CommonDrawerUtils.getDpi(dpi);
        return floatDpi / 72.0f;
    }

    public static float getPageScaleFactor(Integer dpi) {
        float floatDpi = CommonDrawerUtils.getDpi(dpi);
        return 72.0f / floatDpi;
    }

    public static float getTextScaleFactor(Integer dpi) {
        float floatDpi = CommonDrawerUtils.getDpi(dpi);
        return 300.0f / floatDpi;
    }

    public static void initRendering(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }
}

