/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import eu.europa.esig.dss.pdf.visible.FontUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageTextWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTextWriter.class);

    private ImageTextWriter() {
    }

    public static BufferedImage createTextImage(SignatureImageParameters imageParameters) {
        SignatureImageTextParameters textParameters = imageParameters.getTextParameters();
        DSSFont dssFont = textParameters.getFont();
        Font properFont = FontUtils.computeProperFont(dssFont.getJavaFont(), dssFont.getSize(), imageParameters.getDpi());
        Dimension dimension = FontUtils.computeSize(properFont, textParameters.getText(), textParameters.getPadding());
        return ImageTextWriter.createTextImage(textParameters, properFont, dimension);
    }

    public static Dimension getOriginalTextDimension(SignatureImageTextParameters textParameters) {
        DSSFont dssFont = textParameters.getFont();
        Font properFont = FontUtils.computeProperFont(dssFont.getJavaFont(), dssFont.getSize(), CommonDrawerUtils.getDpi(null));
        return FontUtils.computeSize(properFont, textParameters.getText(), textParameters.getPadding());
    }

    private static BufferedImage createTextImage(SignatureImageTextParameters textParameters, Font font, Dimension dimension) {
        int imageType;
        String[] lines = textParameters.getText().split("\n");
        if (ImageTextWriter.isTransparent(textParameters.getTextColor(), textParameters.getBackgroundColor())) {
            LOG.warn("Transparency detected and enabled (Be aware: not valid with PDF/A !)");
            imageType = 2;
        } else {
            imageType = 1;
        }
        BufferedImage img = new BufferedImage(dimension.width, dimension.height, imageType);
        Graphics2D g2 = img.createGraphics();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics(font);
        CommonDrawerUtils.initRendering(g2);
        if (textParameters.getBackgroundColor() == null) {
            g2.setColor(Color.WHITE);
        } else {
            g2.setColor(textParameters.getBackgroundColor());
        }
        g2.fillRect(0, 0, dimension.width, dimension.height);
        if (textParameters.getTextColor() == null) {
            g2.setPaint(Color.BLACK);
        } else {
            g2.setPaint(textParameters.getTextColor());
        }
        int lineHeight = fm.getHeight();
        float y = (float)fm.getMaxAscent() + textParameters.getPadding();
        for (String line : lines) {
            float x = textParameters.getPadding();
            if (textParameters.getSignerTextHorizontalAlignment() != null) {
                switch (textParameters.getSignerTextHorizontalAlignment()) {
                    case RIGHT: {
                        x = (float)(img.getWidth() - fm.stringWidth(line)) - x;
                        break;
                    }
                    case CENTER: {
                        x = (float)(img.getWidth() - fm.stringWidth(line)) / 2.0f;
                        break;
                    }
                }
            }
            g2.drawString(line, x, y);
            y += (float)lineHeight;
        }
        g2.dispose();
        return img;
    }

    private static boolean isTransparent(Color ... colors) {
        if (colors != null) {
            for (Color color : colors) {
                int alpha = color.getAlpha();
                if (alpha >= 255) continue;
                return true;
            }
        }
        return false;
    }
}

