/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pdf.DSSDictionaryExtractionUtils;
import eu.europa.esig.dss.pdf.PdfDict;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PdfVRIDict {
    private final String name;
    private final Map<Long, byte[]> crlMap;
    private final Map<Long, BasicOCSPResp> ocspMap;
    private final Map<Long, CertificateToken> certMap;

    public PdfVRIDict(String name, PdfDict vriDict) {
        this.name = name;
        this.certMap = DSSDictionaryExtractionUtils.getCertsFromArray(vriDict, "VRI/" + name, "Cert");
        this.ocspMap = DSSDictionaryExtractionUtils.getOCSPsFromArray(vriDict, "VRI/" + name, "OCSP");
        this.crlMap = DSSDictionaryExtractionUtils.getCRLsFromArray(vriDict, "VRI/" + name, "CRL");
    }

    public String getName() {
        return this.name;
    }

    public Map<Long, byte[]> getCrlMap() {
        return this.crlMap;
    }

    public Map<Long, BasicOCSPResp> getOcspMap() {
        return this.ocspMap;
    }

    public Map<Long, CertificateToken> getCertMap() {
        return this.certMap;
    }
}

