/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PDFTimestampService;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfObjFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PdfObjFactory.class.getName());
    private static IPdfObjFactory impl;

    private PdfObjFactory() {
    }

    public static void setInstance(IPdfObjFactory instance) {
        if (instance != null) {
            LOG.info("Using '{}' as the PDF Object Factory Implementation", (Object)instance.getClass());
        } else {
            LOG.info("Reseting the PDF Object Factory Implementation");
        }
        impl = instance;
    }

    public static PDFSignatureService newPAdESSignatureService() {
        return impl.newPAdESSignatureService();
    }

    public static PDFTimestampService newTimestampSignatureService() {
        return impl.newTimestampSignatureService();
    }

    static {
        ServiceLoader<IPdfObjFactory> loader = ServiceLoader.load(IPdfObjFactory.class);
        Iterator<IPdfObjFactory> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ExceptionInInitializerError("No implementation found for IPdfObjFactory in classpath, please choose between dss-pades-pdfbox or dss-pades-openpdf");
        }
        impl = iterator.next();
    }
}

