/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pdf.DSSDictionaryExtractionUtils;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDssDict {
    private static final Logger LOG = LoggerFactory.getLogger(PdfDssDict.class);
    private List<PdfVRIDict> vris;
    private final Map<Long, byte[]> crlMap;
    private final Map<Long, BasicOCSPResp> ocspMap;
    private final Map<Long, CertificateToken> certMap;

    public static PdfDssDict extract(PdfDict documentDict) {
        PdfDict dssCatalog;
        if (documentDict != null && (dssCatalog = documentDict.getAsDict("DSS")) != null) {
            return new PdfDssDict(dssCatalog);
        }
        LOG.debug("No DSS dictionary found");
        return null;
    }

    private PdfDssDict(PdfDict dssDictionary) {
        this.readVRI(dssDictionary);
        this.certMap = DSSDictionaryExtractionUtils.getCertsFromArray(dssDictionary, "DSS", "Certs");
        this.ocspMap = DSSDictionaryExtractionUtils.getOCSPsFromArray(dssDictionary, "DSS", "OCSPs");
        this.crlMap = DSSDictionaryExtractionUtils.getCRLsFromArray(dssDictionary, "DSS", "CRLs");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readVRI(PdfDict dssDictionary) {
        PdfDict vriDict = dssDictionary.getAsDict("VRI");
        if (vriDict != null) {
            LOG.debug("There is a VRI dictionary in DSS dictionary");
            try {
                Object[] names = vriDict.list();
                if (!Utils.isArrayNotEmpty(names)) return;
                this.vris = new ArrayList<PdfVRIDict>();
                for (Object name : names) {
                    this.vris.add(new PdfVRIDict((String)name, vriDict.getAsDict((String)name)));
                }
                return;
            }
            catch (Exception e) {
                LOG.debug("Unable to analyse VRI dictionary : {}", (Object)e.getMessage());
                return;
            }
        } else {
            LOG.debug("No VRI dictionary found in DSS dictionary");
        }
    }

    public Map<Long, byte[]> getCRLs() {
        return this.crlMap;
    }

    public Map<Long, BasicOCSPResp> getOCSPs() {
        return this.ocspMap;
    }

    public Map<Long, CertificateToken> getCERTs() {
        return this.certMap;
    }

    public List<PdfVRIDict> getVRIs() {
        return this.vris;
    }
}

