/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfCMSInfo;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSigDict;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDocTimestampInfo
extends PdfCMSInfo
implements PdfSignatureOrDocTimestampInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PdfDocTimestampInfo.class);
    private final TimestampToken timestampToken;

    public PdfDocTimestampInfo(CertificatePool validationCertPool, PdfSigDict signatureDictionary, PdfDssDict timestampedDssDictionary, byte[] cms, byte[] signedContent, boolean coverCompleteRevision) {
        super(signatureDictionary, timestampedDssDictionary, cms, signedContent, coverCompleteRevision);
        try {
            TimestampType timestampType = TimestampType.SIGNATURE_TIMESTAMP;
            if (timestampedDssDictionary != null) {
                timestampType = TimestampType.ARCHIVE_TIMESTAMP;
            }
            this.timestampToken = new TimestampToken(cms, timestampType, validationCertPool, TimestampLocation.DOC_TIMESTAMP);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created PdfDocTimestampInfo {} : {}", (Object)timestampType, (Object)this.uniqueId());
            }
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    @Override
    public void checkIntegrityOnce() {
        SignatureCryptographicVerification signatureCryptographicVerification = new SignatureCryptographicVerification();
        signatureCryptographicVerification.setReferenceDataFound(false);
        signatureCryptographicVerification.setReferenceDataIntact(false);
        signatureCryptographicVerification.setSignatureIntact(false);
        if (this.getSignedDocumentBytes() != null) {
            signatureCryptographicVerification.setReferenceDataFound(true);
        }
        signatureCryptographicVerification.setReferenceDataIntact(this.timestampToken.matchData(this.getSignedDocumentBytes()));
        signatureCryptographicVerification.setSignatureIntact(this.timestampToken.isSignatureValid());
    }

    @Override
    public boolean isTimestamp() {
        return true;
    }

    @Override
    public Date getSigningDate() {
        return this.timestampToken.getGenerationTime();
    }

    public TimestampToken getTimestampToken() {
        return this.timestampToken;
    }
}

