/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.scope.PAdESSignatureScopeFinder;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureValidationCallback;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PDFDocumentValidator
extends SignedDocumentValidator {
    private static final byte[] pdfPreamble = new byte[]{37, 80, 68, 70, 45};
    private final PDFSignatureService pdfSignatureService;

    PDFDocumentValidator() {
        super(null);
        this.pdfSignatureService = null;
    }

    public PDFDocumentValidator(DSSDocument document) {
        super(new PAdESSignatureScopeFinder());
        this.document = document;
        this.pdfSignatureService = PdfObjFactory.newPAdESSignatureService();
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return DSSUtils.compareFirstBytes(dssDocument, pdfPreamble);
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        final ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        this.pdfSignatureService.validateSignatures(this.validationCertPool, this.document, new PdfSignatureValidationCallback(){

            @Override
            public void validate(PdfSignatureInfo pdfSignatureInfo) {
                try {
                    if (pdfSignatureInfo.getCades() != null) {
                        PAdESSignature padesSignature = new PAdESSignature(PDFDocumentValidator.this.document, pdfSignatureInfo, PDFDocumentValidator.this.validationCertPool);
                        padesSignature.setSignatureFilename(PDFDocumentValidator.this.document.getName());
                        padesSignature.setProvidedSigningCertificateToken(PDFDocumentValidator.this.providedSigningCertificateToken);
                        signatures.add(padesSignature);
                    }
                }
                catch (Exception e) {
                    throw new DSSException(e);
                }
            }
        });
        return signatures;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank(signatureId)) {
            throw new NullPointerException("signatureId");
        }
        List<AdvancedSignature> signatures = this.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!signature.getId().equals(signatureId)) continue;
            return this.getOriginalDocuments(signature);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) throws DSSException {
        PAdESSignature padesSignature = (PAdESSignature)advancedSignature;
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        InMemoryDocument originalPDF = PAdESUtils.getOriginalPDF(padesSignature);
        if (originalPDF != null) {
            result.add(originalPDF);
        }
        return result;
    }
}

