/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESTimestampSource;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PAdESTimestampDataBuilder;
import eu.europa.esig.dss.pdf.PdfDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.List;

public class PAdESTimestampSource
extends CAdESTimestampSource {
    private final transient PdfSignatureInfo pdfSignatureInfo;

    public PAdESTimestampSource(PAdESSignature signature, CertificatePool certificatePool) {
        super(signature, certificatePool);
        this.pdfSignatureInfo = signature.getPdfSignatureInfo();
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        if (this.getSignatureTimestamps() == null || this.getArchiveTimestamps() == null) {
            this.createAndValidate();
        }
        ArrayList<TimestampToken> documentTimestamps = new ArrayList<TimestampToken>();
        documentTimestamps.addAll(this.getSignatureTimestamps());
        documentTimestamps.addAll(this.getArchiveTimestamps());
        return documentTimestamps;
    }

    @Override
    protected PAdESTimestampDataBuilder getTimestampDataBuilder() {
        PAdESTimestampDataBuilder padesTimestampDataBuilder = new PAdESTimestampDataBuilder(this.pdfSignatureInfo, this.signerInformation, this.detachedDocuments);
        padesTimestampDataBuilder.setSignatureTimestamps(this.getSignatureTimestamps());
        return padesTimestampDataBuilder;
    }

    @Override
    protected void makeTimestampTokens() {
        super.makeTimestampTokens();
        ArrayList<TimestampToken> timestampedTimestamps = new ArrayList<TimestampToken>(this.getSignatureTimestamps());
        ArrayList<CertificateToken> cmsContentCertificates = new ArrayList<CertificateToken>();
        List<PdfSignatureOrDocTimestampInfo> outerSignatures = this.pdfSignatureInfo.getOuterSignatures();
        for (PdfSignatureOrDocTimestampInfo outerSignature : outerSignatures) {
            if (!outerSignature.isTimestamp() || !(outerSignature instanceof PdfDocTimestampInfo)) continue;
            PdfDocTimestampInfo timestampInfo = (PdfDocTimestampInfo)outerSignature;
            TimestampToken timestampToken = new TimestampToken(timestampInfo.getTimestampToken());
            timestampToken.getTimestampedReferences().clear();
            if (TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampToken.getTimeStampType())) {
                timestampToken.getTimestampedReferences().addAll(this.getSignatureTimestampReferences());
                this.getSignatureTimestamps().add(timestampToken);
            } else {
                timestampToken.setArchiveTimestampType(this.getArchiveTimestampType());
                List<TimestampedReference> references = new ArrayList<TimestampedReference>();
                if (Utils.isCollectionEmpty(this.getSignatureTimestamps())) {
                    references = this.getSignatureTimestampReferences();
                }
                this.addReferencesForPreviousTimestamps(references, timestampedTimestamps);
                PdfDssDict coveredDSSDictionary = timestampInfo.getDssDictionary();
                PAdESCertificateSource padesCertificateSource = new PAdESCertificateSource(coveredDSSDictionary, timestampInfo.getCMSSignedData(), this.certificatePool);
                this.addReferences(references, this.createReferencesForCertificates(cmsContentCertificates));
                this.addReferencesForCertificates(references, padesCertificateSource);
                this.addReferencesFromRevocationData(references, coveredDSSDictionary);
                cmsContentCertificates.addAll(this.getCMSContentReferences(padesCertificateSource));
                timestampToken.getTimestampedReferences().addAll(references);
                this.getArchiveTimestamps().add(timestampToken);
            }
            this.populateTimestampCertificateSource(timestampToken.getCertificates());
            timestampedTimestamps.add(timestampToken);
        }
    }

    @Override
    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List<TimestampedReference> signatureTimestampReferences = super.getSignatureTimestampReferences();
        this.addReferences(signatureTimestampReferences, this.createReferencesForCertificates(this.signatureCertificateSource.getKeyInfoCertificates()));
        return signatureTimestampReferences;
    }

    private List<CertificateToken> getCMSContentReferences(PAdESCertificateSource padesCertificateSource) {
        List<CertificateToken> keyInfoCertificates = padesCertificateSource.getKeyInfoCertificates();
        this.populateTimestampCertificateSource(keyInfoCertificates);
        return keyInfoCertificates;
    }

    private void addReferencesForCertificates(List<TimestampedReference> references, PAdESCertificateSource padesCertificateSource) {
        List<CertificateToken> dssDictionaryCertValues = padesCertificateSource.getDSSDictionaryCertValues();
        this.addReferences(references, this.createReferencesForCertificates(dssDictionaryCertValues));
        this.populateTimestampCertificateSource(dssDictionaryCertValues);
        List<CertificateToken> vriDictionaryCertValues = padesCertificateSource.getVRIDictionaryCertValues();
        this.addReferences(references, this.createReferencesForCertificates(vriDictionaryCertValues));
        this.populateTimestampCertificateSource(vriDictionaryCertValues);
    }

    private void addReferencesFromRevocationData(List<TimestampedReference> references, PdfDssDict dssDictionary) {
        PAdESCRLSource padesCRLSource = new PAdESCRLSource(dssDictionary);
        for (CRLBinary crlIdentifier : padesCRLSource.getCRLBinaryList()) {
            if (!padesCRLSource.getRevocationOrigins(crlIdentifier).contains((Object)RevocationOrigin.DSS_DICTIONARY) && !padesCRLSource.getRevocationOrigins(crlIdentifier).contains((Object)RevocationOrigin.VRI_DICTIONARY)) continue;
            this.addReference(references, new TimestampedReference(crlIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        this.crlSource.addAll(padesCRLSource);
        PAdESOCSPSource padesOCSPSource = new PAdESOCSPSource(dssDictionary);
        for (OCSPResponseBinary ocspIdentifier : padesOCSPSource.getOCSPResponsesList()) {
            if (!padesOCSPSource.getRevocationOrigins(ocspIdentifier).contains((Object)RevocationOrigin.DSS_DICTIONARY) && !padesOCSPSource.getRevocationOrigins(ocspIdentifier).contains((Object)RevocationOrigin.VRI_DICTIONARY)) continue;
            this.addReference(references, new TimestampedReference(ocspIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        this.ocspSource.addAll(padesOCSPSource);
    }

    @Override
    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    private ArchiveTimestampType getArchiveTimestampType() {
        return this.getArchiveTimestampType((CAdESAttribute)null);
    }

    @Override
    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        return ArchiveTimestampType.PAdES;
    }
}

