/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cms.SignerInformation;

public class PAdESTimestampDataBuilder
extends CAdESTimestampDataBuilder {
    private final PdfSignatureInfo pdfSignatureInfo;
    private List<TimestampToken> signatureTimestamps = new ArrayList<TimestampToken>();

    public PAdESTimestampDataBuilder(PdfSignatureInfo pdfSignatureInfo, SignerInformation signerInformation, List<DSSDocument> detacheDocuments) {
        super(signerInformation, detacheDocuments);
        this.pdfSignatureInfo = pdfSignatureInfo;
    }

    public void setSignatureTimestamps(List<TimestampToken> signatureTimestamps) {
        this.signatureTimestamps = signatureTimestamps;
    }

    @Override
    public byte[] getSignatureTimestampData(TimestampToken timestampToken) {
        for (PdfSignatureOrDocTimestampInfo signatureInfo : this.pdfSignatureInfo.getOuterSignatures()) {
            PdfDocTimestampInfo pdfTimestampInfo;
            if (!(signatureInfo instanceof PdfDocTimestampInfo) || !(pdfTimestampInfo = (PdfDocTimestampInfo)signatureInfo).getTimestampToken().equals(timestampToken)) continue;
            byte[] signedDocumentBytes = pdfTimestampInfo.getSignedDocumentBytes();
            return signedDocumentBytes;
        }
        if (this.signatureTimestamps.contains(timestampToken)) {
            return super.getSignatureTimestampData(timestampToken);
        }
        throw new DSSException("Timestamp Data not found");
    }

    @Override
    public byte[] getTimestampX1Data(TimestampToken timestampToken) {
        return null;
    }

    @Override
    public byte[] getTimestampX2Data(TimestampToken timestampToken) {
        return null;
    }

    @Override
    public byte[] getArchiveTimestampData(TimestampToken timestampToken) {
        for (PdfSignatureOrDocTimestampInfo signatureInfo : this.pdfSignatureInfo.getOuterSignatures()) {
            PdfDocTimestampInfo pdfTimestampInfo;
            if (!(signatureInfo instanceof PdfDocTimestampInfo) || !(pdfTimestampInfo = (PdfDocTimestampInfo)signatureInfo).getTimestampToken().equals(timestampToken)) continue;
            byte[] signedDocumentBytes = pdfTimestampInfo.getSignedDocumentBytes();
            return signedDocumentBytes;
        }
        throw new DSSException("Timestamp Data not found");
    }
}

