/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CAdESCertificateSource;
import eu.europa.esig.dss.validation.CertificateRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cms.CMSSignedData;

public class PAdESCertificateSource
extends CAdESCertificateSource {
    private final PdfDssDict dssDictionary;

    public PAdESCertificateSource(PdfDssDict dssDictionary, CMSSignedData cmsSignedData, CertificatePool certPool) {
        super(cmsSignedData, certPool);
        this.dssDictionary = dssDictionary;
        this.extractFromDSSDict();
    }

    private void extractFromDSSDict() {
        Map<Long, CertificateToken> certificateMap = this.getCertificateMap();
        for (CertificateToken certToken : certificateMap.values()) {
            this.addCertificate(certToken);
        }
    }

    public Map<Long, CertificateToken> getCertificateMap() {
        if (this.dssDictionary != null) {
            Map<Long, CertificateToken> dssCerts = this.dssDictionary.getCERTs();
            List<PdfVRIDict> vriDicts = this.dssDictionary.getVRIs();
            if (Utils.isCollectionNotEmpty(vriDicts)) {
                for (PdfVRIDict vriDict : vriDicts) {
                    dssCerts.putAll(vriDict.getCertMap());
                }
            }
            return dssCerts;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<CertificateToken> getCertificateValues() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateRef> getCompleteCertificateRefs() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateRef> getAttributeCertificateRefs() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateToken> getDSSDictionaryCertValues() {
        if (this.dssDictionary != null) {
            Map<Long, CertificateToken> dssCerts = this.dssDictionary.getCERTs();
            return new ArrayList<CertificateToken>(dssCerts.values());
        }
        return Collections.emptyList();
    }

    @Override
    public List<CertificateToken> getVRIDictionaryCertValues() {
        if (this.dssDictionary != null) {
            HashMap<Long, CertificateToken> vriCerts = new HashMap<Long, CertificateToken>();
            List<PdfVRIDict> vris = this.dssDictionary.getVRIs();
            if (vris != null) {
                for (PdfVRIDict vri : vris) {
                    vriCerts.putAll(vri.getCertMap());
                }
            }
            return new ArrayList<CertificateToken>(vriCerts.values());
        }
        return Collections.emptyList();
    }
}

