/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLT;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;

class PAdESLevelBaselineLTA
implements SignatureExtension<PAdESSignatureParameters> {
    private final PAdESLevelBaselineLT padesLevelBaselineLT;
    private final PAdESLevelBaselineT padesLevelBaselineT;
    private final CertificateVerifier certificateVerifier;

    public PAdESLevelBaselineLTA(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        this.padesLevelBaselineLT = new PAdESLevelBaselineLT(tspSource, certificateVerifier);
        this.padesLevelBaselineT = new PAdESLevelBaselineT(tspSource);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters parameters) throws DSSException {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        document = this.padesLevelBaselineLT.extendSignatures(document, parameters);
        return this.padesLevelBaselineT.extendSignatures(document, parameters);
    }
}

