/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.AbstractDSSFont;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;

public class DSSFileFont
extends AbstractDSSFont {
    private static final String DEFAULT_FONT_NAME = "PTSerifRegular.ttf";
    private static final DSSDocument DEFAULT_FONT = new InMemoryDocument(SignatureImageTextParameters.class.getResourceAsStream("/fonts/PTSerifRegular.ttf"), "PTSerifRegular.ttf");
    private static final String DEFAULT_FONT_EXTENSION = ".ttf";
    private DSSDocument fileFont;

    public static DSSFileFont initializeDefault() {
        return new DSSFileFont(DEFAULT_FONT);
    }

    public DSSFileFont(InputStream inputStream) {
        this(new InMemoryDocument(inputStream));
    }

    public DSSFileFont(DSSDocument dssDocument) {
        this(dssDocument, 12.0f);
    }

    public DSSFileFont(DSSDocument dssDocument, float size) {
        this.fileFont = dssDocument;
        this.size = size;
        this.initFontName(dssDocument);
        this.initJavaFont(dssDocument);
    }

    private void initFontName(DSSDocument fileFont) {
        if (Utils.isStringBlank(fileFont.getName())) {
            fileFont.setName(DSSUtils.getMD5Digest(DSSUtils.toByteArray(fileFont)) + DEFAULT_FONT_EXTENSION);
        }
    }

    private void initJavaFont(DSSDocument fileFont) {
        try (InputStream is = fileFont.openStream();){
            Font javaFont = Font.createFont(0, is);
            this.javaFont = javaFont.deriveFont(this.size);
        }
        catch (FontFormatException | IOException e) {
            throw new DSSException("The assigned font cannot be initialized", e);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.fileFont.openStream();
    }

    @Override
    public String getName() {
        return this.fileFont.getName();
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public boolean isLogicalFont() {
        return false;
    }
}

