/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;

public class InMemoryDocument
extends CommonDocument {
    private byte[] bytes;

    public InMemoryDocument() {
    }

    public InMemoryDocument(byte[] bytes) {
        this(bytes, null, null);
    }

    public InMemoryDocument(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
        this.mimeType = MimeType.fromFileName(name);
    }

    public InMemoryDocument(byte[] bytes, String name, MimeType mimeType) {
        this.bytes = bytes;
        this.name = name;
        this.mimeType = mimeType;
    }

    public InMemoryDocument(InputStream inputStream) {
        this(InMemoryDocument.toByteArray(inputStream), null, null);
    }

    public InMemoryDocument(InputStream inputStream, String name) {
        this(InMemoryDocument.toByteArray(inputStream), name);
    }

    public InMemoryDocument(InputStream inputStream, String name, MimeType mimeType) {
        this(InMemoryDocument.toByteArray(inputStream), name, mimeType);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] toByteArray(InputStream inputStream) {
        try (InputStream is = inputStream;){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[2048];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, nRead);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new DSSException("Unable to fully read the InputStream", e);
        }
    }

    @Override
    public InputStream openStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getBase64Encoded() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }
}

