/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileDocument
extends CommonDocument {
    private final File file;

    public FileDocument(String path) {
        this(new File(path));
    }

    public FileDocument(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.exists()) {
            throw new DSSException("File Not Found: " + file.getAbsolutePath());
        }
        this.file = file;
        this.name = file.getName();
        this.mimeType = MimeType.fromFileName(file.getName());
    }

    @Override
    public InputStream openStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new DSSException("Unable to create a FileInputStream", e);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getParentFile() {
        return this.file.getParentFile();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }
}

