/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;

public class DigestDocument
extends CommonDocument {
    public DigestDocument() {
    }

    public DigestDocument(DigestAlgorithm digestAlgorithm, String base64EncodeDigest) {
        this.addDigest(digestAlgorithm, base64EncodeDigest);
    }

    public DigestDocument(DigestAlgorithm digestAlgorithm, String base64EncodeDigest, String name) {
        this(digestAlgorithm, base64EncodeDigest);
        this.name = name;
    }

    public void addDigest(DigestAlgorithm digestAlgorithm, String base64EncodeDigest) {
        this.base64EncodeDigestMap.put(digestAlgorithm, base64EncodeDigest);
    }

    @Override
    public String getDigest(DigestAlgorithm digestAlgorithm) {
        String base64EncodeDigest = (String)this.base64EncodeDigestMap.get(digestAlgorithm);
        if (base64EncodeDigest == null) {
            throw new DSSException("Unknown digest value for algorithm : " + digestAlgorithm);
        }
        return base64EncodeDigest;
    }

    public Digest getExistingDigest() {
        if (!this.base64EncodeDigestMap.isEmpty()) {
            Map.Entry digestEntry = this.base64EncodeDigestMap.entrySet().iterator().next();
            return new Digest((DigestAlgorithm)digestEntry.getKey(), Base64.getDecoder().decode((String)digestEntry.getValue()));
        }
        throw new DSSException("The DigestDocument does not contain any digest! You must specify it by using addDigest() method.");
    }

    @Override
    public InputStream openStream() {
        throw new DSSException("Digest document");
    }

    @Override
    public void save(String filePath) throws IOException {
        throw new DSSException("Digest document");
    }
}

