/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder<CAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureScopeFinder.class);

    @Override
    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
        return this.getSignatureScopeFromOriginalDocument(originalDocument);
    }

    protected List<SignatureScope> getSignatureScopeFromOriginalDocument(DSSDocument originalDocument) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        if (originalDocument == null) {
            return result;
        }
        if (originalDocument instanceof DigestDocument) {
            DigestDocument digestDocument = (DigestDocument)originalDocument;
            result.add(new DigestSignatureScope("Digest document", digestDocument.getExistingDigest()));
        } else {
            String digest64Base = originalDocument.getDigest(this.getDefaultDigestAlgorithm());
            result.add(new FullSignatureScope("Full document", new Digest(this.getDefaultDigestAlgorithm(), Utils.fromBase64(digest64Base))));
        }
        return result;
    }

    protected DSSDocument getOriginalDocument(CAdESSignature cadesSignature) {
        try {
            return cadesSignature.getOriginalDocument();
        }
        catch (DSSException e) {
            LOG.warn("A CAdES signer's original document is not found [{}].", (Object)e.getMessage());
            return null;
        }
    }
}

