/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSigProperties;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.validation.timestamp.TimeStampTokenProductionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.SignerInformation;

public class CAdESUnsignedAttributes
extends CAdESSigProperties {
    private static List<ASN1ObjectIdentifier> timestampOids = new ArrayList<ASN1ObjectIdentifier>();

    CAdESUnsignedAttributes(AttributeTable attributeTable) {
        super(attributeTable);
    }

    public static CAdESUnsignedAttributes build(SignerInformation signerInformation) {
        return new CAdESUnsignedAttributes(signerInformation.getUnsignedAttributes());
    }

    @Override
    public List<CAdESAttribute> getAttributes() {
        return this.sortTimestamps(super.getAttributes());
    }

    private List<CAdESAttribute> sortTimestamps(List<CAdESAttribute> attributes) {
        TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
        for (int ii = 0; ii < attributes.size() - 1; ++ii) {
            for (int jj = 0; jj < attributes.size() - ii - 1; ++jj) {
                CAdESAttribute cadesAttribute = attributes.get(jj);
                if (!timestampOids.contains(cadesAttribute.getASN1Oid())) continue;
                CAdESAttribute nextCAdESAttribute = attributes.get(jj + 1);
                if (!timestampOids.contains(nextCAdESAttribute.getASN1Oid())) {
                    Collections.swap(attributes, jj, jj + 1);
                    continue;
                }
                if (comparator.compare(cadesAttribute.toTimeStampToken(), nextCAdESAttribute.toTimeStampToken()) <= 0) continue;
                Collections.swap(attributes, jj, jj + 1);
            }
        }
        return attributes;
    }

    static {
        timestampOids.add(OID.id_aa_ets_archiveTimestampV2);
        timestampOids.add(OID.id_aa_ets_archiveTimestampV3);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
    }
}

