/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cms.CMSSignedData;

public class CMSSignedDocument
extends CommonDocument {
    protected CMSSignedData signedData;

    public CMSSignedDocument(CMSSignedData data) {
        this.signedData = data;
        if (data == null) {
            throw new NullPointerException("The CMSSignedData cannot be null");
        }
        this.mimeType = MimeType.PKCS7;
    }

    @Override
    public InputStream openStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public CMSSignedData getCMSSignedData() {
        return this.signedData;
    }

    public byte[] getBytes() {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            DEROutputStream derOutputStream = new DEROutputStream(output);
            byte[] encoded = this.signedData.getEncoded();
            Object asn1Primitive = DSSASN1Utils.toASN1Primitive(encoded);
            derOutputStream.writeObject((ASN1Encodable)asn1Primitive);
            derOutputStream.close();
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(e);
            }
        }
        output.close();
        return byArray;
    }

    public String getBase64Encoded() {
        return Utils.toBase64(this.getBytes());
    }

    @Override
    public String getAbsolutePath() {
        return super.getName();
    }
}

