/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLTA;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.cades.signature.CustomMessageDigestCalculatorProvider;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESService
extends AbstractSignatureService<CAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESService.class);
    private final CMSSignedDataBuilder cmsSignedDataBuilder;

    public CAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.cmsSignedDataBuilder = new CMSSignedDataBuilder(certificateVerifier);
        LOG.debug("+ CAdESService created");
    }

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, CAdESSignatureParameters parameters) {
        if (this.tspSource == null) {
            throw new DSSException("A TSPSource is required !");
        }
        DigestAlgorithm digestAlgorithm = parameters.getContentTimestampParameters().getDigestAlgorithm();
        TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, Utils.fromBase64(toSignDocument.getDigest(digestAlgorithm)));
        return new TimestampToken(timeStampResponse, TimestampType.CONTENT_TIMESTAMP);
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, CAdESSignatureParameters parameters) throws DSSException {
        this.assertSigningDateInCertificateValidityRange(parameters);
        SignaturePackaging packaging = parameters.getSignaturePackaging();
        this.assertSignaturePackaging(packaging);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        DigestCalculatorProvider dcp = this.getDigestCalculatorProvider(toSignDocument, parameters);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.cmsSignedDataBuilder.getSignerInfoGeneratorBuilder(dcp, parameters, false);
        CMSSignedData originalCmsSignedData = this.getCmsSignedData(toSignDocument, parameters);
        CMSSignedDataGenerator cmsSignedDataGenerator = this.cmsSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, originalCmsSignedData);
        DSSDocument toSignData = this.getToSignData(toSignDocument, parameters, originalCmsSignedData);
        CMSTypedData content = CMSUtils.getContentToBeSign(toSignData);
        boolean encapsulate = !SignaturePackaging.DETACHED.equals((Object)packaging);
        CMSUtils.generateCMSSignedData(cmsSignedDataGenerator, content, encapsulate);
        byte[] bytes = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(bytes);
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, CAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        this.assertSigningDateInCertificateValidityRange(parameters);
        SignaturePackaging packaging = parameters.getSignaturePackaging();
        this.assertSignaturePackaging(packaging);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        DigestCalculatorProvider dcp = this.getDigestCalculatorProvider(toSignDocument, parameters);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.cmsSignedDataBuilder.getSignerInfoGeneratorBuilder(dcp, parameters, true);
        CMSSignedData originalCmsSignedData = this.getCmsSignedData(toSignDocument, parameters);
        if (originalCmsSignedData == null && SignaturePackaging.DETACHED.equals((Object)packaging) && Utils.isCollectionEmpty(parameters.getDetachedContents())) {
            parameters.setDetachedContents(Arrays.asList(toSignDocument));
        }
        CMSSignedDataGenerator cmsSignedDataGenerator = this.cmsSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, originalCmsSignedData);
        DSSDocument toSignData = this.getToSignData(toSignDocument, parameters, originalCmsSignedData);
        CMSTypedData content = CMSUtils.getContentToBeSign(toSignData);
        boolean encapsulate = !SignaturePackaging.DETACHED.equals((Object)packaging);
        CMSSignedData cmsSignedData = CMSUtils.generateCMSSignedData(cmsSignedDataGenerator, content, encapsulate);
        DSSDocument signature = new CMSSignedDocument(cmsSignedData);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)signatureLevel)) {
            SignatureExtension<CAdESSignatureParameters> extension = this.getExtensionProfile(parameters, true);
            signature = extension.extendSignatures(signature, parameters);
        }
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        parameters.reinitDeterministicId();
        return signature;
    }

    private DigestCalculatorProvider getDigestCalculatorProvider(DSSDocument toSignDocument, CAdESSignatureParameters parameters) {
        DigestAlgorithm referenceDigestAlgorithm = parameters.getReferenceDigestAlgorithm();
        if (referenceDigestAlgorithm != null) {
            return new CustomMessageDigestCalculatorProvider(referenceDigestAlgorithm, toSignDocument.getDigest(referenceDigestAlgorithm));
        }
        if (toSignDocument instanceof DigestDocument) {
            return new PrecomputedDigestCalculatorProvider((DigestDocument)toSignDocument);
        }
        return new BcDigestCalculatorProvider();
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, CAdESSignatureParameters parameters) {
        SignatureExtension<CAdESSignatureParameters> extension = this.getExtensionProfile(parameters, false);
        DSSDocument dssDocument = extension.extendSignatures(toExtendDocument, parameters);
        dssDocument.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
        return dssDocument;
    }

    private DSSDocument getToSignData(DSSDocument toSignDocument, CAdESSignatureParameters parameters, CMSSignedData originalCmsSignedData) {
        List<DSSDocument> detachedContents = parameters.getDetachedContents();
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            return detachedContents.get(0);
        }
        if (originalCmsSignedData == null) {
            return toSignDocument;
        }
        return this.getSignedContent(originalCmsSignedData);
    }

    private DSSDocument getSignedContent(CMSSignedData cmsSignedData) {
        if (cmsSignedData != null) {
            CMSTypedData signedContent = cmsSignedData.getSignedContent();
            byte[] documentBytes = signedContent != null ? (byte[])signedContent.getContent() : null;
            InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
            return inMemoryDocument;
        }
        return null;
    }

    private SignatureExtension<CAdESSignatureParameters> getExtensionProfile(CAdESSignatureParameters parameters, boolean onlyLastCMSSignature) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        switch (signatureLevel) {
            case CAdES_BASELINE_T: {
                return new CAdESLevelBaselineT(this.tspSource, onlyLastCMSSignature);
            }
            case CAdES_BASELINE_LT: {
                return new CAdESLevelBaselineLT(this.tspSource, this.certificateVerifier, onlyLastCMSSignature);
            }
            case CAdES_BASELINE_LTA: {
                return new CAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier, onlyLastCMSSignature);
            }
        }
        throw new DSSException("Unsupported signature format " + (Object)((Object)signatureLevel));
    }

    private CMSSignedData getCmsSignedData(DSSDocument dssDocument, CAdESSignatureParameters parameters) {
        CMSSignedData cmsSignedData = null;
        if (!(dssDocument instanceof DigestDocument) && DSSASN1Utils.isASN1SequenceTag(DSSUtils.readFirstByte(dssDocument))) {
            try {
                cmsSignedData = new CMSSignedData(DSSUtils.toByteArray(dssDocument));
                if (SignaturePackaging.ENVELOPING == parameters.getSignaturePackaging() && cmsSignedData.getSignedContent().getContent() == null) {
                    cmsSignedData = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cmsSignedData;
    }

    private void assertSignaturePackaging(SignaturePackaging packaging) throws DSSException {
        if (packaging != SignaturePackaging.ENVELOPING && packaging != SignaturePackaging.DETACHED) {
            throw new DSSException("Unsupported signature packaging: " + (Object)((Object)packaging));
        }
    }
}

