/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimeStampTokenProductionComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineLTA
extends CAdESSignatureExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineLTA.class);
    private final CAdESLevelBaselineLT cadesProfileLT;
    private static final List<ASN1ObjectIdentifier> archiveTimestampOIDs = new ArrayList<ASN1ObjectIdentifier>();

    public CAdESLevelBaselineLTA(TSPSource tspSource, CertificateVerifier certificateVerifier, boolean onlyLastSigner) {
        super(tspSource, onlyLastSigner);
        this.cadesProfileLT = new CAdESLevelBaselineLT(tspSource, certificateVerifier, onlyLastSigner);
    }

    @Override
    protected CMSSignedData preExtendCMSSignedData(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        if (!this.includesArchiveTimestamps(cmsSignedData)) {
            cmsSignedData = this.cadesProfileLT.extendCMSSignatures(cmsSignedData, parameters);
        }
        return cmsSignedData;
    }

    private boolean includesArchiveTimestamps(CMSSignedData cmsSignedData) {
        SignerInformation signerInformation = cmsSignedData.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        return this.getLastArchiveTimestamp(unsignedAttributes) != null;
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        try {
            unsignedAttributes = this.addValidationData(unsignedAttributes, parameters);
            signerInformation = SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
        }
        catch (IOException | CMSException | TSPException e) {
            LOG.warn("Validation data to a timestamp was not added due the error : {}", (Object)e.getMessage());
        }
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
        cadesSignature.setDetachedContents(parameters.getDetachedContents());
        unsignedAttributes = this.addArchiveTimestampV3Attribute(cadesSignature, signerInformation, parameters, unsignedAttributes);
        return SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
    }

    private AttributeTable addValidationData(AttributeTable unsignedAttributes, CAdESSignatureParameters parameters) throws IOException, CMSException, TSPException {
        TimeStampToken timestampTokenToExtend = this.getLastArchiveTimestamp(unsignedAttributes);
        if (timestampTokenToExtend != null) {
            CMSSignedData timestampCMSSignedData = timestampTokenToExtend.toCMSSignedData();
            CMSSignedData extendedTimestampCMSSignedData = this.cadesProfileLT.postExtendCMSSignedData(timestampCMSSignedData, this.getFirstSigner(timestampCMSSignedData), parameters.getDetachedContents());
            unsignedAttributes = CMSUtils.replaceAttribute(unsignedAttributes, timestampCMSSignedData, extendedTimestampCMSSignedData);
        }
        return unsignedAttributes;
    }

    private TimeStampToken getLastArchiveTimestamp(AttributeTable unsignedAttributes) {
        TimeStampToken lastTimeStampToken = null;
        for (ASN1ObjectIdentifier identifier : archiveTimestampOIDs) {
            lastTimeStampToken = this.getLastTimeStampTokenWithOid(lastTimeStampToken, unsignedAttributes, identifier);
        }
        return lastTimeStampToken;
    }

    private TimeStampToken getLastTimeStampTokenWithOid(TimeStampToken lastTimeStampToken, AttributeTable unsignedAttributes, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
        for (TimeStampToken timeStampToken : DSSASN1Utils.findTimeStampTokens(unsignedAttributes, asn1ObjectIdentifier)) {
            if (lastTimeStampToken != null && !comparator.after(timeStampToken, lastTimeStampToken)) continue;
            lastTimeStampToken = timeStampToken;
        }
        return lastTimeStampToken;
    }

    private AttributeTable addArchiveTimestampV3Attribute(CAdESSignature cadesSignature, SignerInformation signerInformation, CAdESSignatureParameters parameters, AttributeTable unsignedAttributes) {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(cadesSignature);
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        byte[] originalDocumentDigest = Utils.fromBase64(cadesSignature.getOriginalDocument().getDigest(timestampDigestAlgorithm));
        Attribute atsHashIndexAttribute = timestampExtractor.getAtsHashIndex(signerInformation, timestampDigestAlgorithm);
        byte[] encodedToTimestamp = timestampExtractor.getArchiveTimestampDataV3(signerInformation, atsHashIndexAttribute, originalDocumentDigest);
        ASN1Object timeStampAttributeValue = this.getTimeStampAttributeValue(encodedToTimestamp, timestampDigestAlgorithm, new Attribute[]{atsHashIndexAttribute});
        return unsignedAttributes.add(OID.id_aa_ets_archiveTimestampV3, timeStampAttributeValue);
    }

    static {
        archiveTimestampOIDs.add(OID.id_aa_ets_archiveTimestampV2);
        archiveTimestampOIDs.add(OID.id_aa_ets_archiveTimestampV3);
    }
}

