/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    protected List<DocumentValidator> validators;
    protected ASiCExtractResult extractResult;
    private ASiCContainerType containerType;

    private AbstractASiCContainerValidator() {
        super(null);
        this.document = null;
    }

    protected AbstractASiCContainerValidator(DSSDocument document) {
        super(null);
        this.document = document;
    }

    protected void analyseEntries() {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor();
        this.extractResult = extractor.extract();
        this.containerType = ASiCUtils.getContainerType(this.document, this.extractResult.getMimeTypeDocument(), this.extractResult.getZipComment(), this.extractResult.getSignedDocuments());
        if (ASiCContainerType.ASiC_S.equals((Object)this.containerType)) {
            this.extractResult.setContainerDocuments(this.getArchiveDocuments(this.extractResult.getSignedDocuments()));
        } else if (ASiCContainerType.ASiC_E.equals((Object)this.containerType)) {
            this.extractResult.setManifestFiles(this.getManifestFilesDecriptions());
        }
    }

    protected abstract AbstractASiCContainerExtractor getArchiveExtractor();

    public ASiCContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public List<AdvancedSignature> prepareSignatureValidationContext(ValidationContext validationContext) {
        ArrayList<AdvancedSignature> allSignatures = new ArrayList<AdvancedSignature>();
        List<DocumentValidator> currentValidators = this.getValidators();
        for (DocumentValidator documentValidator : currentValidators) {
            allSignatures.addAll(documentValidator.prepareSignatureValidationContext(validationContext));
        }
        List<TimestampToken> externalTimestamps = this.attachExternalTimestamps(allSignatures);
        for (TimestampToken timestamp : externalTimestamps) {
            this.addTimestampTokenForVerification(validationContext, timestamp);
        }
        return allSignatures;
    }

    private void addTimestampTokenForVerification(ValidationContext validationContext, TimestampToken timestamp) {
        validationContext.addTimestampTokenForVerification(timestamp);
        for (CertificateToken certificate : timestamp.getCertificates()) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
    }

    @Override
    protected ContainerInfo getContainerInfo() {
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.containerType);
        containerInfo.setZipComment(this.extractResult.getZipComment());
        DSSDocument mimeTypeDocument = this.extractResult.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray(mimeTypeDocument));
            containerInfo.setMimeTypeFilePresent(true);
            containerInfo.setMimeTypeContent(mimeTypeContent);
        } else {
            containerInfo.setMimeTypeFilePresent(false);
        }
        List<DSSDocument> signedDocuments = this.extractResult.getSignedDocuments();
        if (Utils.isCollectionNotEmpty(signedDocuments)) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : signedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFiles());
        return containerInfo;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        return Collections.emptyList();
    }

    protected abstract List<ManifestFile> getManifestFilesDecriptions();

    @Override
    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> allSignatures = new ArrayList<AdvancedSignature>();
        List<DocumentValidator> currentValidators = this.getValidators();
        for (DocumentValidator documentValidator : currentValidators) {
            allSignatures.addAll(documentValidator.getSignatures());
        }
        return allSignatures;
    }

    protected abstract List<DocumentValidator> getValidators();

    protected List<DSSDocument> getSignatureDocuments() {
        return this.extractResult.getSignatureDocuments();
    }

    protected List<DSSDocument> getSignedDocuments() {
        return this.extractResult.getSignedDocuments();
    }

    protected List<DSSDocument> getManifestDocuments() {
        return this.extractResult.getManifestDocuments();
    }

    protected List<ManifestFile> getManifestFiles() {
        return this.extractResult.getManifestFiles();
    }

    protected List<DSSDocument> getTimestampDocuments() {
        return this.extractResult.getTimestampDocuments();
    }

    protected List<DSSDocument> getTimestampedDocuments(DSSDocument timestamp) {
        return this.extractResult.getTimestampedDocuments(timestamp);
    }

    protected List<DSSDocument> getArchiveManifestDocuments() {
        return this.extractResult.getArchiveManifestDocuments();
    }

    protected List<DSSDocument> getArchiveDocuments() {
        return this.extractResult.getContainerDocuments();
    }

    protected DSSDocument getMimeTypeDocument() {
        return this.extractResult.getMimeTypeDocument();
    }

    private List<DSSDocument> getArchiveDocuments(List<DSSDocument> foundDocuments) {
        ArrayList<DSSDocument> archiveDocuments = new ArrayList<DSSDocument>();
        for (DSSDocument document : foundDocuments) {
            if (!this.isASiCSArchive(document)) continue;
            archiveDocuments.addAll(this.getPackageZipContent(document));
            break;
        }
        return archiveDocuments;
    }

    protected List<DSSDocument> getSignedDocumentsASiCS(List<DSSDocument> retrievedDocs) {
        if (Utils.collectionSize(retrievedDocs) > 1) {
            throw new DSSException("ASiC-S : More than one file");
        }
        DSSDocument uniqueDoc = retrievedDocs.get(0);
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        if (this.isASiCSArchive(uniqueDoc)) {
            result.addAll(this.getPackageZipContent(uniqueDoc));
        } else {
            result.add(uniqueDoc);
        }
        return result;
    }

    private boolean isASiCSArchive(DSSDocument document) {
        return Utils.areStringsEqual("package.zip", document.getName());
    }

    private List<DSSDocument> getPackageZipContent(DSSDocument packageZip) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        long containerSize = DSSUtils.getFileByteSize(packageZip);
        try (InputStream is = packageZip.openStream();
             ZipInputStream packageZipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = ASiCUtils.getNextValidEntry(packageZipInputStream)) != null) {
                result.add(ASiCUtils.getCurrentDocument(entry.getName(), packageZipInputStream, containerSize));
            }
        }
        catch (IOException e) {
            throw new DSSException("Unable to extract package.zip", e);
        }
        return result;
    }
}

