/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractASiCSignatureService<SP extends AbstractSignatureParameters>
extends AbstractSignatureService<SP>
implements MultipleDocumentsSignatureService<SP> {
    private static final long serialVersionUID = 243114076381526665L;
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file";
    private static final String ZIP_ENTRY_MIMETYPE = "mimetype";
    protected ASiCExtractResult archiveContent = new ASiCExtractResult();

    protected AbstractASiCSignatureService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected abstract String getExpectedSignatureExtension();

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, SP parameters) {
        return this.getContentTimestamp(Arrays.asList(toSignDocument), parameters);
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, SP parameters) {
        return this.getDataToSign(Arrays.asList(toSignDocument), parameters);
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, SP parameters, SignatureValue signatureValue) {
        return this.signDocument(Arrays.asList(toSignDocument), parameters, signatureValue);
    }

    protected void extractCurrentArchive(DSSDocument archive) {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor(archive);
        this.archiveContent = extractor.extract();
    }

    protected abstract AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument var1);

    protected List<DSSDocument> getEmbeddedSignatures() {
        return this.archiveContent.getSignatureDocuments();
    }

    protected List<DSSDocument> getEmbeddedManifests() {
        return this.archiveContent.getManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedArchiveManifests() {
        return this.archiveContent.getArchiveManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedTimestamps() {
        return this.archiveContent.getTimestampDocuments();
    }

    protected List<DSSDocument> getEmbeddedSignedDocuments() {
        return this.archiveContent.getSignedDocuments();
    }

    protected DSSDocument getEmbeddedMimetype() {
        return this.archiveContent.getMimeTypeDocument();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected DSSDocument mergeArchiveAndExtendedSignatures(DSSDocument archiveDocument, List<DSSDocument> signaturesToAdd) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            InMemoryDocument inMemoryDocument;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                this.copyArchiveContentWithoutSignatures(archiveDocument, zos, signaturesToAdd);
                this.storeDocuments(signaturesToAdd, zos);
                zos.finish();
                inMemoryDocument = new InMemoryDocument(baos.toByteArray(), null, archiveDocument.getMimeType());
            }
            return inMemoryDocument;
        }
        catch (IOException e) {
            throw new DSSException("Unable to extend the ASiC container", e);
        }
    }

    private void copyArchiveContentWithoutSignatures(DSSDocument archiveDocument, ZipOutputStream zos, List<DSSDocument> documentsToAdd) throws IOException {
        List<String> documentNames = this.getDocumentNames(documentsToAdd);
        long containerSize = DSSUtils.getFileByteSize(archiveDocument);
        try (InputStream is = archiveDocument.openStream();
             ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = ASiCUtils.getNextValidEntry(zis)) != null) {
                String name = entry.getName();
                ZipEntry newEntry = new ZipEntry(name);
                if (this.isSignatureFilename(name) || documentNames.contains(name)) continue;
                zos.putNextEntry(newEntry);
                ASiCUtils.secureCopy(zis, zos, containerSize);
            }
        }
    }

    protected abstract boolean isSignatureFilename(String var1);

    private List<String> getDocumentNames(List<DSSDocument> documents) {
        ArrayList<String> names = new ArrayList<String>();
        for (DSSDocument document : documents) {
            names.add(document.getName());
        }
        return names;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected DSSDocument buildASiCContainer(List<DSSDocument> documentsToBeSigned, List<DSSDocument> signatures, List<DSSDocument> manifestDocuments, ASiCParameters asicParameters) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            InMemoryDocument inMemoryDocument;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                if (ASiCUtils.isASiCE(asicParameters)) {
                    this.storeDocuments(manifestDocuments, zos);
                }
                this.storeDocuments(signatures, zos);
                this.storeSignedFiles(documentsToBeSigned, zos);
                this.storeMimetype(asicParameters, zos);
                this.storeZipComment(asicParameters, zos);
                zos.finish();
                inMemoryDocument = new InMemoryDocument(baos.toByteArray(), null, ASiCUtils.getMimeType(asicParameters));
            }
            return inMemoryDocument;
        }
        catch (IOException e) {
            throw new DSSException("Unable to build the ASiC Container", e);
        }
    }

    private void storeDocuments(List<DSSDocument> documents, ZipOutputStream zos) throws IOException {
        for (DSSDocument doc : documents) {
            ZipEntry entrySignature = new ZipEntry(doc.getName());
            zos.putNextEntry(entrySignature);
            doc.writeTo(zos);
        }
    }

    private void storeSignedFiles(List<DSSDocument> detachedDocuments, ZipOutputStream zos) throws IOException {
        for (DSSDocument detachedDocument : detachedDocuments) {
            InputStream is = detachedDocument.openStream();
            try {
                String detachedDocumentName = detachedDocument.getName();
                String name = detachedDocumentName != null ? detachedDocumentName : ZIP_ENTRY_DETACHED_FILE;
                ZipEntry entryDocument = new ZipEntry(name);
                zos.setLevel(8);
                zos.putNextEntry(entryDocument);
                Utils.copy(is, zos);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private void storeMimetype(ASiCParameters asicParameters, ZipOutputStream zos) throws IOException {
        byte[] mimeTypeBytes = ASiCUtils.getMimeTypeString(asicParameters).getBytes("UTF-8");
        ZipEntry entryMimetype = this.getZipEntryMimeType(mimeTypeBytes);
        zos.putNextEntry(entryMimetype);
        Utils.write(mimeTypeBytes, zos);
    }

    private ZipEntry getZipEntryMimeType(byte[] mimeTypeBytes) {
        ZipEntry entryMimetype = new ZipEntry(ZIP_ENTRY_MIMETYPE);
        entryMimetype.setMethod(0);
        entryMimetype.setSize(mimeTypeBytes.length);
        entryMimetype.setCompressedSize(mimeTypeBytes.length);
        CRC32 crc = new CRC32();
        crc.update(mimeTypeBytes);
        entryMimetype.setCrc(crc.getValue());
        return entryMimetype;
    }

    protected void storeZipComment(ASiCParameters asicParameters, ZipOutputStream zos) {
        if (asicParameters.isZipComment()) {
            zos.setComment("mimetype=" + ASiCUtils.getMimeTypeString(asicParameters));
        }
    }
}

