/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.AbstractDataToSignASiCEWithCAdES;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCEWithCAdESFromArchive
extends AbstractDataToSignASiCEWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> signedDocuments;
    private final List<DSSDocument> existingSignatures;
    private final List<DSSDocument> existingManifests;
    private final ASiCWithCAdESSignatureParameters parameters;
    private DSSDocument toBeSigned;

    public DataToSignASiCEWithCAdESFromArchive(List<DSSDocument> signedDocuments, List<DSSDocument> existingSignatures, List<DSSDocument> existingManifests, ASiCWithCAdESSignatureParameters parameters) {
        this.signedDocuments = signedDocuments;
        this.existingSignatures = existingSignatures;
        this.existingManifests = existingManifests;
        this.parameters = parameters;
    }

    @Override
    public String getSignatureFilename() {
        return this.getSignatureFileName(this.parameters.aSiC(), this.existingSignatures);
    }

    @Override
    public DSSDocument getToBeSigned() {
        if (this.toBeSigned == null) {
            this.toBeSigned = this.getASiCManifest(this.signedDocuments, this.existingSignatures, this.existingManifests, this.parameters);
        }
        return this.toBeSigned;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getSignedDocuments() {
        return this.signedDocuments;
    }

    @Override
    public List<DSSDocument> getManifestFiles() {
        ArrayList<DSSDocument> manifests = new ArrayList<DSSDocument>(this.existingManifests);
        manifests.add(this.getToBeSigned());
        return manifests;
    }

    @Override
    public List<DSSDocument> getSignatures() {
        return this.existingSignatures;
    }
}

