/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.signature.asice.ASiCEWithCAdESManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public abstract class AbstractDataToSignASiCEWithCAdES {
    private static final String META_INF = "META-INF/";
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE = "META-INF/signature001.p7s";

    protected DSSDocument getASiCManifest(List<DSSDocument> documents, List<DSSDocument> signatures, List<DSSDocument> manifests, ASiCWithCAdESSignatureParameters parameters) {
        ASiCEWithCAdESManifestBuilder manifestBuilder = new ASiCEWithCAdESManifestBuilder(documents, parameters.getDigestAlgorithm(), this.getSignatureFileName(parameters.aSiC(), signatures));
        return DomUtils.createDssDocumentFromDomDocument(manifestBuilder.build(), this.getASiCManifestFilename(manifests));
    }

    protected String getSignatureFileName(ASiCParameters asicParameters, List<DSSDocument> existingSignatures) {
        if (Utils.isStringNotBlank(asicParameters.getSignatureFileName())) {
            return META_INF + asicParameters.getSignatureFileName();
        }
        int num = Utils.collectionSize(existingSignatures) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE.replace("001", ASiCUtils.getPadNumber(num));
    }

    private String getASiCManifestFilename(List<DSSDocument> existingManifests) {
        String suffix = Utils.isCollectionEmpty(existingManifests) ? "" : String.valueOf(existingManifests.size());
        return "META-INF/ASiCManifest" + suffix + ".xml";
    }
}

