/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.ASiCEWithCAdESArchiveManifestBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestParser;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCWithCAdESService
extends AbstractASiCSignatureService<ASiCWithCAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESService.class);
    private static final String ARCHIVE_MANIFEST_EXTENSION = ".xml";
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_ARCHIVE_MANIFEST = "META-INF/ASiCArchiveManifest";
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_TIMESTAMP = "META-INF/timestamp001.tst";
    private static final String DEFAULT_ARCHIVE_MANIFEST_FILENAME = "META-INF/ASiCArchiveManifest.xml";

    public ASiCWithCAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with CAdES created");
    }

    @Override
    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        GetDataToSignASiCWithCAdESHelper getDataToSignHelper = ASiCWithCAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        return this.getCAdESService().getContentTimestamp(getDataToSignHelper.getToBeSigned(), parameters);
    }

    @Override
    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = ASiCWithCAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.setDetachedContents(dataToSignHelper.getDetachedContents());
        return this.getCAdESService().getDataToSign(dataToSignHelper.getToBeSigned(), cadesParameters);
    }

    @Override
    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters, SignatureValue signatureValue) {
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSigningDateInCertificateValidityRange(parameters);
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = ASiCWithCAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        List<DSSDocument> signatures = dataToSignHelper.getSignatures();
        List<DSSDocument> manifests = dataToSignHelper.getManifestFiles();
        List<DSSDocument> archiveManifests = this.getEmbeddedArchiveManifests();
        List<DSSDocument> timestamps = this.getEmbeddedTimestamps();
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.setDetachedContents(dataToSignHelper.getDetachedContents());
        boolean addASiCArchiveManifest = this.isAddASiCEArchiveManifest(parameters);
        if (this.isAddASiCEArchiveManifest(parameters)) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        DSSDocument signature = this.getCAdESService().signDocument(dataToSignHelper.getToBeSigned(), cadesParameters, signatureValue);
        String newSignatureFileName = dataToSignHelper.getSignatureFilename();
        signature.setName(dataToSignHelper.getSignatureFilename());
        if (ASiCUtils.isASiCS(asicParameters)) {
            Iterator<DSSDocument> iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual(newSignatureFileName, iterator.next().getName())) continue;
                iterator.remove();
            }
        }
        signatures.add(signature);
        if (addASiCArchiveManifest) {
            String timestampFilename = this.getArchiveTimestampFilename(timestamps);
            ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(signatures, timestamps, dataToSignHelper.getSignedDocuments(), manifests, null, parameters.getArchiveTimestampParameters().getDigestAlgorithm(), timestampFilename);
            DSSDocument archiveManfest = DomUtils.createDssDocumentFromDomDocument(builder.build(), this.getArchiveManifestFilename(archiveManifests));
            signatures.add(archiveManfest);
            DigestAlgorithm digestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
            TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, DSSUtils.digest(digestAlgorithm, archiveManfest));
            InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getDEREncoded(timeStampResponse), timestampFilename, MimeType.TST);
            signatures.add(timestamp);
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument asicSignature = this.buildASiCContainer(dataToSignHelper.getSignedDocuments(), signatures, manifests, asicParameters);
        asicSignature.setName(this.getFinalFileName(asicSignature, SigningOperation.SIGN, parameters.getSignatureLevel(), parameters.aSiC().getContainerType()));
        parameters.reinitDeterministicId();
        return asicSignature;
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithCAdESSignatureParameters parameters) {
        if (!ASiCUtils.isASiCContainer(toExtendDocument) || !ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension(toExtendDocument, ".p7s")) {
            throw new DSSException("Unsupported file type");
        }
        this.extractCurrentArchive(toExtendDocument);
        List<DSSDocument> signatureDocuments = this.getEmbeddedSignatures();
        List<DSSDocument> signedDocuments = this.getEmbeddedSignedDocuments();
        DSSDocument mimetype = this.getEmbeddedMimetype();
        ASiCContainerType containerType = ASiCUtils.getContainerType(toExtendDocument, mimetype, null, signedDocuments);
        if (containerType == null) {
            throw new DSSException("Unable to determine container type");
        }
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        boolean addASiCEArchiveManifest = this.isAddASiCEArchiveManifest(parameters);
        if (addASiCEArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        for (DSSDocument signature : signatureDocuments) {
            if (!addASiCEArchiveManifest || !this.isCoveredByArchiveManifest(signature)) {
                DSSDocument extendedSignature = this.extendSignatureDocument(signature, cadesParameters, containerType);
                extendedDocuments.add(extendedSignature);
                continue;
            }
            extendedDocuments.add(signature);
        }
        if (addASiCEArchiveManifest) {
            this.extendWithArchiveManifest(parameters, extendedDocuments);
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toExtendDocument, extendedDocuments);
        extensionResult.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), parameters.aSiC().getContainerType()));
        return extensionResult;
    }

    private boolean isCoveredByArchiveManifest(DSSDocument signature) {
        List<DSSDocument> archiveManifests = this.getEmbeddedArchiveManifests();
        if (Utils.isCollectionNotEmpty(archiveManifests)) {
            for (DSSDocument archiveManifest : archiveManifests) {
                ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(archiveManifest);
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    if (signature.getName() == null || !signature.getName().equals(entry.getFileName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private DSSDocument extendSignatureDocument(DSSDocument signature, CAdESSignatureParameters cadesParameters, ASiCContainerType containerType) {
        List<DSSDocument> manifests = this.getEmbeddedManifests();
        List<DSSDocument> signedDocuments = this.getEmbeddedSignedDocuments();
        if (ASiCContainerType.ASiC_E == containerType) {
            DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(manifests, signature.getName());
            if (linkedManifest != null) {
                String originalName = signature.getName();
                cadesParameters.setDetachedContents(Arrays.asList(linkedManifest));
                DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
                extendDocument.setName(originalName);
                return extendDocument;
            }
            LOG.warn("Manifest not found for signature file '{}' -> NOT EXTENDED !!!", (Object)signature.getName());
            return signature;
        }
        String originalName = signature.getName();
        cadesParameters.setDetachedContents(signedDocuments);
        DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
        extendDocument.setName(originalName);
        return extendDocument;
    }

    private void extendWithArchiveManifest(ASiCWithCAdESSignatureParameters parameters, List<DSSDocument> extendedDocuments) {
        List<DSSDocument> archiveManifests = this.getEmbeddedArchiveManifests();
        List<DSSDocument> timestamps = this.getEmbeddedTimestamps();
        List<DSSDocument> manifests = this.getEmbeddedManifests();
        List<DSSDocument> signedDocuments = this.getEmbeddedSignedDocuments();
        String timestampFilename = this.getArchiveTimestampFilename(timestamps);
        DSSDocument lastTimestamp = this.getLastTimestamp(timestamps);
        DSSDocument lastArchiveManifest = null;
        if (lastTimestamp != null) {
            DSSDocument extendedArchiveTimestamp = this.extendArchiveTimestamp(lastTimestamp, parameters.getDetachedContents());
            timestamps.remove(lastTimestamp);
            extendedDocuments.add(extendedArchiveTimestamp);
            for (DSSDocument manifest : archiveManifests) {
                if (DEFAULT_ARCHIVE_MANIFEST_FILENAME.equals(manifest.getName())) {
                    manifest.setName(this.getArchiveManifestFilename(archiveManifests));
                    lastArchiveManifest = manifest;
                    continue;
                }
                manifests.add(manifest);
            }
        }
        ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(extendedDocuments, timestamps, signedDocuments, manifests, lastArchiveManifest, parameters.getArchiveTimestampParameters().getDigestAlgorithm(), timestampFilename);
        DSSDocument archiveManifest = DomUtils.createDssDocumentFromDomDocument(builder.build(), DEFAULT_ARCHIVE_MANIFEST_FILENAME);
        extendedDocuments.add(archiveManifest);
        if (lastArchiveManifest != null) {
            extendedDocuments.add(lastArchiveManifest);
        }
        DigestAlgorithm digestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
        TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, DSSUtils.digest(digestAlgorithm, archiveManifest));
        InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getDEREncoded(timeStampResponse), timestampFilename, MimeType.TST);
        extendedDocuments.add(timestamp);
    }

    private DSSDocument getLastTimestamp(List<DSSDocument> timestamps) {
        DSSDocument lastTimestamp = null;
        for (DSSDocument timestamp : timestamps) {
            if (lastTimestamp != null && lastTimestamp.getName().compareTo(timestamp.getName()) >= 0) continue;
            lastTimestamp = timestamp;
        }
        return lastTimestamp;
    }

    private DSSDocument extendArchiveTimestamp(DSSDocument archiveTimestamp, List<DSSDocument> detachedContents) {
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData(archiveTimestamp);
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        CMSSignedData extendedCMSSignedData = cmsSignedDataBuilder.extendCMSSignedData(cmsSignedData, cmsSignedData.getSignerInfos().iterator().next(), detachedContents);
        InMemoryDocument extendedTimestamp = new InMemoryDocument(DSSASN1Utils.getEncoded(extendedCMSSignedData), archiveTimestamp.getName(), MimeType.TST);
        return extendedTimestamp;
    }

    private String getArchiveManifestFilename(List<DSSDocument> archiveManifests) {
        String suffix = Utils.isCollectionEmpty(archiveManifests) ? "" : String.valueOf(archiveManifests.size());
        return ZIP_ENTRY_ASICE_METAINF_CADES_ARCHIVE_MANIFEST + suffix + ARCHIVE_MANIFEST_EXTENSION;
    }

    private String getArchiveTimestampFilename(List<DSSDocument> timestamps) {
        int num = Utils.collectionSize(timestamps) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_TIMESTAMP.replace("001", ASiCUtils.getPadNumber(num));
    }

    @Override
    protected boolean isSignatureFilename(String name) {
        return ASiCUtils.isCAdES(name);
    }

    @Override
    protected AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithCAdESContainerExtractor(archive);
    }

    private CAdESService getCAdESService() {
        CAdESService cadesService = new CAdESService(this.certificateVerifier);
        cadesService.setTspSource(this.tspSource);
        return cadesService;
    }

    private CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters) {
        ASiCWithCAdESSignatureParameters cadesParameters = parameters;
        cadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        cadesParameters.setDetachedContents(null);
        return cadesParameters;
    }

    private boolean isAddASiCEArchiveManifest(ASiCWithCAdESSignatureParameters parameters) {
        return SignatureLevel.CAdES_BASELINE_LTA == parameters.getSignatureLevel() && ASiCContainerType.ASiC_E == parameters.aSiC().getContainerType();
    }

    @Override
    protected String getExpectedSignatureExtension() {
        return ".p7s";
    }
}

