/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdES111XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdES122XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.scope.XAdESSignatureScopeFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLDocumentValidator
extends SignedDocumentValidator {
    private static final byte[] xmlPreamble = new byte[]{60};
    private static final byte[] xmlWithBomPreample = new byte[]{-17, -69, -65, 60};
    protected List<XPathQueryHolder> xPathQueryHolders;
    protected Document rootElement;
    private List<AdvancedSignature> signatures;

    XMLDocumentValidator() {
        super(null);
    }

    public XMLDocumentValidator(DSSDocument dssDocument) {
        super(new XAdESSignatureScopeFinder());
        this.document = dssDocument;
        this.rootElement = DomUtils.buildDOM(dssDocument);
        this.xPathQueryHolders = new ArrayList<XPathQueryHolder>();
        XAdES111XPathQueryHolder xades111xPathQueryHolder = new XAdES111XPathQueryHolder();
        this.xPathQueryHolders.add(xades111xPathQueryHolder);
        XAdES122XPathQueryHolder xades122XPathQueryHolder = new XAdES122XPathQueryHolder();
        this.xPathQueryHolders.add(xades122XPathQueryHolder);
        XPathQueryHolder xPathQueryHolder = new XPathQueryHolder();
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return DSSUtils.compareFirstBytes(dssDocument, xmlPreamble) || DSSUtils.compareFirstBytes(dssDocument, xmlWithBomPreample);
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures != null) {
            return this.signatures;
        }
        this.signatures = new ArrayList<AdvancedSignature>();
        NodeList signatureNodeList = DomUtils.getNodeList(this.rootElement, "//ds:Signature[not(parent::xades:CounterSignature)]");
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            XAdESSignature xadesSignature = new XAdESSignature(signatureEl, this.xPathQueryHolders, this.validationCertPool);
            xadesSignature.setSignatureFilename(this.document.getName());
            xadesSignature.setDetachedContents(this.detachedContents);
            xadesSignature.setContainerContents(this.containerContents);
            xadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            this.signatures.add(xadesSignature);
        }
        return this.signatures;
    }

    public AdvancedSignature getSignatureById(String signatureId) throws DSSException {
        if (Utils.isStringBlank(signatureId)) {
            throw new NullPointerException("signatureId");
        }
        List<AdvancedSignature> advancedSignatures = this.getSignatures();
        for (AdvancedSignature advancedSignature : advancedSignatures) {
            String advancedSignatureId = advancedSignature.getId();
            if (!signatureId.equals(advancedSignatureId)) continue;
            return advancedSignature;
        }
        throw new DSSException("The signature with the given id was not found!");
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank(signatureId)) {
            throw new NullPointerException("signatureId");
        }
        List<AdvancedSignature> signatureList = this.getSignatures();
        for (AdvancedSignature advancedSignature : signatureList) {
            if (!signatureId.equals(advancedSignature.getId())) continue;
            return this.getOriginalDocuments(advancedSignature);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) throws DSSException {
        XAdESSignature signature = (XAdESSignature)advancedSignature;
        return XAdESSignatureUtils.getSignerDocuments(signature);
    }

    public List<XPathQueryHolder> getXPathQueryHolder() {
        return this.xPathQueryHolders;
    }

    public void addXPathQueryHolder(XPathQueryHolder xPathQueryHolder) {
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    public void clearQueryHolders() {
        this.xPathQueryHolders.clear();
    }

    public Document getRootElement() {
        return this.rootElement;
    }
}

