/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.ResponderId;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESOCSPSource
extends SignatureOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESOCSPSource.class);
    private final Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;

    public XAdESOCSPSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        Objects.requireNonNull(signatureElement, "Signature element cannot be null");
        Objects.requireNonNull(xPathQueryHolder, "XPathQueryHolder cannot be null");
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
        this.appendContainedOCSPResponses();
    }

    @Override
    public void appendContainedOCSPResponses() {
        this.collect(this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP, RevocationOrigin.REVOCATION_VALUES);
        this.collect(this.xPathQueryHolder.XPATH_ATTR_REV_ENCAPSULATED_OCSP_VALUES, RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
        this.collect(this.xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_OCSP_VALUES, RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
        this.collectRefs(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_OCSP_REFS, RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        this.collectRefs(this.xPathQueryHolder.XPATH_ATTRIBUTE_REVOCATION_OCSP_REFS, RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    private void collect(String xPathQuery, RevocationOrigin origin) {
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element ocspValueEl = (Element)nodeList.item(ii);
            this.convertAndAppend(ocspValueEl.getTextContent(), origin);
        }
    }

    private void collectRefs(String xPathQuery, RevocationRefOrigin revocationRefOrigin) {
        Element ocspRefsElement = DomUtils.getElement(this.signatureElement, xPathQuery);
        if (ocspRefsElement != null) {
            NodeList ocspRefNodes = DomUtils.getNodeList(ocspRefsElement, this.xPathQueryHolder.XPATH__OCSPREF);
            for (int i = 0; i < ocspRefNodes.getLength(); ++i) {
                Element ocspRefElement = (Element)ocspRefNodes.item(i);
                OCSPRef ocspRef = this.createOCSPRef(ocspRefElement, revocationRefOrigin);
                if (ocspRef == null) continue;
                this.addReference(ocspRef, revocationRefOrigin);
            }
        }
    }

    private OCSPRef createOCSPRef(Element ocspRefElement, RevocationRefOrigin revocationRefOrigin) {
        ResponderId responderId = new ResponderId();
        Element responderIdEl = DomUtils.getElement(ocspRefElement, this.xPathQueryHolder.XPATH__OCSP_RESPONDER_ID_ELEMENT);
        if (responderIdEl != null && responderIdEl.hasChildNodes()) {
            Element responderIdByName = DomUtils.getElement(responderIdEl, this.xPathQueryHolder.XPATH__RESPONDER_ID_BY_NAME);
            if (responderIdByName != null) {
                responderId.setName(responderIdByName.getTextContent());
            } else {
                Element responderIdByKey = DomUtils.getElement(responderIdEl, this.xPathQueryHolder.XPATH__RESPONDER_ID_BY_KEY);
                if (responderIdByKey != null) {
                    responderId.setKey(Utils.fromBase64(responderIdByKey.getTextContent()));
                }
            }
        }
        if (responderId.getName() == null && responderId.getKey() == null) {
            return null;
        }
        Date producedAtDate = null;
        Element producedAtEl = DomUtils.getElement(ocspRefElement, this.xPathQueryHolder.XPATH__OCSP_PRODUCED_AT_DATETIME);
        if (producedAtEl != null) {
            producedAtDate = DomUtils.getDate(producedAtEl.getTextContent());
        }
        if (producedAtDate == null) {
            return null;
        }
        Digest digest = DSSXMLUtils.getRevocationDigest(ocspRefElement, this.xPathQueryHolder);
        if (digest == null) {
            return null;
        }
        return new OCSPRef(digest, producedAtDate, responderId, revocationRefOrigin);
    }

    private void convertAndAppend(String ocspValue, RevocationOrigin origin) {
        try {
            this.addOCSPResponse(OCSPResponseBinary.build(DSSRevocationUtils.loadOCSPBase64Encoded(ocspValue)), origin);
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve OCSP response from '" + ocspValue + "' : " + e.getMessage(), e);
        }
    }
}

