/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.IssuerSerialInfo;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESCertificateSource.class);
    private final Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;
    private List<CertificateToken> keyInfoCertificates;
    private List<CertificateToken> certificateValues;
    private List<CertificateToken> attrAuthoritiesCertValues;
    private List<CertificateToken> timeStampValidationDataCertValues;
    private List<CertificateRef> signingCertificateValues;
    private List<CertificateRef> completeCertificateRefs;
    private List<CertificateRef> attributeCertificateRefs;

    public XAdESCertificateSource(Element signatureElement, XPathQueryHolder xPathQueryHolder, CertificatePool certificatePool) {
        super(certificatePool);
        Objects.requireNonNull(signatureElement, "Element signature must not be null");
        Objects.requireNonNull(xPathQueryHolder, "XPathQueryHolder must not be null");
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
        this.getKeyInfoCertificates();
        this.getCertificateValues();
        this.getAttrAuthoritiesCertValues();
        this.getTimeStampValidationDataCertValues();
        if (LOG.isInfoEnabled()) {
            LOG.info("+XAdESCertificateSource");
        }
    }

    @Override
    public List<CertificateToken> getKeyInfoCertificates() {
        if (this.keyInfoCertificates == null) {
            this.keyInfoCertificates = this.getCertificates(this.xPathQueryHolder.XPATH_KEY_INFO_X509_CERTIFICATE);
        }
        return this.keyInfoCertificates;
    }

    @Override
    public List<CertificateToken> getCertificateValues() {
        if (this.certificateValues == null) {
            this.certificateValues = this.getCertificates(this.xPathQueryHolder.XPATH_ENCAPSULATED_X509_CERTIFICATE);
        }
        return this.certificateValues;
    }

    @Override
    public List<CertificateToken> getAttrAuthoritiesCertValues() {
        if (this.attrAuthoritiesCertValues == null) {
            this.attrAuthoritiesCertValues = this.getCertificates(this.xPathQueryHolder.XPATH_AUTH_ENCAPSULATED_X509_CERTIFICATE);
        }
        return this.attrAuthoritiesCertValues;
    }

    @Override
    public List<CertificateToken> getTimeStampValidationDataCertValues() {
        if (this.timeStampValidationDataCertValues == null) {
            this.timeStampValidationDataCertValues = this.getCertificates(this.xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_X509_CERTIFICATE);
        }
        return this.timeStampValidationDataCertValues;
    }

    private List<CertificateToken> getCertificates(String xPathQuery) {
        ArrayList<CertificateToken> list = new ArrayList<CertificateToken>();
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certificateElement = (Element)nodeList.item(ii);
            byte[] derEncoded = Utils.fromBase64(certificateElement.getTextContent());
            try {
                CertificateToken cert = DSSUtils.loadCertificate(derEncoded);
                CertificateToken certToken = this.addCertificate(cert);
                if (list.contains(certToken)) continue;
                list.add(certToken);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse certificate '{}' : {}", (Object)certificateElement.getTextContent(), (Object)e.getMessage());
            }
        }
        return list;
    }

    @Override
    public List<CertificateRef> getSigningCertificateValues() {
        if (this.signingCertificateValues == null) {
            this.signingCertificateValues = new ArrayList<CertificateRef>();
            NodeList list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_CERTIFICATE_CERT);
            if (list != null && list.getLength() != 0) {
                this.signingCertificateValues.addAll(this.extractXAdESCertsV1(list, CertificateRefOrigin.SIGNING_CERTIFICATE));
            }
            if ((list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_CERTIFICATE_CERT_V2)) != null && list.getLength() != 0) {
                this.signingCertificateValues.addAll(this.extractXAdESCertsV2(list, CertificateRefOrigin.SIGNING_CERTIFICATE));
            }
            if (Utils.isCollectionEmpty(this.signingCertificateValues)) {
                LOG.warn("No signing certificate tag found");
            }
        }
        return this.signingCertificateValues;
    }

    @Override
    public List<CertificateRef> getCompleteCertificateRefs() {
        if (this.completeCertificateRefs == null) {
            this.completeCertificateRefs = new ArrayList<CertificateRef>();
            NodeList list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CCR_CERT_REFS_CERT);
            if (list != null && list.getLength() != 0) {
                this.completeCertificateRefs.addAll(this.extractXAdESCertsV1(list, CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS));
            }
            if ((list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CCRV2_CERT_REFS_CERT)) != null && list.getLength() != 0) {
                this.completeCertificateRefs.addAll(this.extractXAdESCertsV2(list, CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS));
            }
        }
        return this.completeCertificateRefs;
    }

    @Override
    public List<CertificateRef> getAttributeCertificateRefs() {
        if (this.attributeCertificateRefs == null) {
            this.attributeCertificateRefs = new ArrayList<CertificateRef>();
            NodeList list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_ACR_CERT_REFS_CERT);
            if (list != null && list.getLength() != 0) {
                this.attributeCertificateRefs.addAll(this.extractXAdESCertsV1(list, CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS));
            }
            if ((list = DomUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_ACRV2_CERT_REFS_CERT)) != null && list.getLength() != 0) {
                this.attributeCertificateRefs.addAll(this.extractXAdESCertsV2(list, CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS));
            }
        }
        return this.attributeCertificateRefs;
    }

    private List<CertificateRef> extractXAdESCertsV1(NodeList list, CertificateRefOrigin location) {
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        for (int i = 0; i < list.getLength(); ++i) {
            Digest certDigest;
            Element element = (Element)list.item(i);
            if (element == null || (certDigest = DSSXMLUtils.getCertDigest(element, this.xPathQueryHolder)) == null) continue;
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(certDigest);
            certRef.setIssuerInfo(this.getIssuerV1(element));
            certRef.setOrigin(location);
            result.add(certRef);
        }
        return result;
    }

    private List<CertificateRef> extractXAdESCertsV2(NodeList list, CertificateRefOrigin location) {
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        for (int i = 0; i < list.getLength(); ++i) {
            Digest certDigest;
            Element element = (Element)list.item(i);
            if (element == null || (certDigest = DSSXMLUtils.getCertDigest(element, this.xPathQueryHolder)) == null) continue;
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(certDigest);
            certRef.setIssuerInfo(this.getIssuerV2(element));
            certRef.setOrigin(location);
            result.add(certRef);
        }
        return result;
    }

    private IssuerSerialInfo getIssuerV1(Element element) {
        Element serialNumberEl;
        IssuerSerialInfo issuerInfo = new IssuerSerialInfo();
        Element issuerNameEl = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_ISSUER_NAME);
        if (issuerNameEl != null) {
            issuerInfo.setIssuerName(DSSUtils.getX500PrincipalOrNull(issuerNameEl.getTextContent()));
        }
        if ((serialNumberEl = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_SERIAL_NUMBER)) != null) {
            String serialNumberText = serialNumberEl.getTextContent();
            issuerInfo.setSerialNumber(new BigInteger(serialNumberText.trim()));
        }
        return issuerInfo;
    }

    private IssuerSerialInfo getIssuerV2(Element element) {
        Element issuerSerialV2Element = DomUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_ISSUER_V2);
        if (issuerSerialV2Element == null) {
            return null;
        }
        String textContent = issuerSerialV2Element.getTextContent();
        return this.getIssuerInfo(DSSASN1Utils.getIssuerSerial(Utils.fromBase64(textContent)));
    }
}

