/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.Objects;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESCRLSource
extends SignatureCRLSource {
    public XAdESCRLSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        Objects.requireNonNull(signatureElement, "Signature element cannot be null");
        Objects.requireNonNull(xPathQueryHolder, "XPathQueryHolder cannot be null");
        this.collect(signatureElement, xPathQueryHolder.XPATH_CRL_VALUES_ENCAPSULATED_CRL, RevocationOrigin.REVOCATION_VALUES);
        this.collect(signatureElement, xPathQueryHolder.XPATH_ATTR_REV_ENCAPSULATED_CRL_VALUES, RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
        this.collect(signatureElement, xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_CRL_VALUES, RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
        this.collectRefs(signatureElement, xPathQueryHolder, xPathQueryHolder.XPATH_COMPLETE_REVOCATION_CRL_REFS, RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        this.collectRefs(signatureElement, xPathQueryHolder, xPathQueryHolder.XPATH_ATTRIBUTE_REVOCATION_CRL_REFS, RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    private void collect(Element signatureElement, String xPathQuery, RevocationOrigin revocationOrigin) {
        NodeList nodeList = DomUtils.getNodeList(signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element crlValueEl = (Element)nodeList.item(ii);
            this.addCRLBinary(Utils.fromBase64(crlValueEl.getTextContent()), revocationOrigin);
        }
    }

    private void collectRefs(Element signatureElement, XPathQueryHolder xPathQueryHolder, String xPathQuery, RevocationRefOrigin revocationRefOrigin) {
        Element crlRefsElement = DomUtils.getElement(signatureElement, xPathQuery);
        if (crlRefsElement != null) {
            NodeList crlRefNodes = DomUtils.getNodeList(crlRefsElement, xPathQueryHolder.XPATH__CRLREF);
            for (int i = 0; i < crlRefNodes.getLength(); ++i) {
                Element crlRefNode = (Element)crlRefNodes.item(i);
                Digest digest = DSSXMLUtils.getRevocationDigest(crlRefNode, xPathQueryHolder);
                CRLRef crlRef = new CRLRef(digest, revocationRefOrigin);
                this.addReference(crlRef, revocationRefOrigin);
            }
        }
    }
}

