/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        if (dssDocument == null) {
            throw new NullPointerException();
        }
        if (this.tspSource == null) {
            throw new NullPointerException();
        }
        this.params = params;
        ProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: {}", (Object)(dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentDom = DomUtils.buildDOM(dssDocument);
        NodeList signatureNodeList = this.documentDom.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new DSSException("There is no signature to extend!");
        }
        String signatureId = null;
        SignaturePackaging signaturePackaging = params.getSignaturePackaging();
        ProfileParameters.Operation operationKind = context.getOperationKind();
        if (ProfileParameters.Operation.SIGNING.equals((Object)operationKind) && SignaturePackaging.ENVELOPED.equals((Object)signaturePackaging)) {
            signatureId = params.getDeterministicId();
        }
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            this.currentSignatureDom = (Element)signatureNodeList.item(ii);
            String currentSignatureId = this.currentSignatureDom.getAttribute("Id");
            if (signatureId != null && !signatureId.equals(currentSignatureId)) continue;
            this.xadesSignature = new XAdESSignature(this.currentSignatureDom, Arrays.asList(new XPathQueryHolder()), this.certificateVerifier.createValidationPool());
            this.xadesSignature.setDetachedContents(params.getDetachedContents());
            this.extendSignatureTag();
        }
        return this.createXmlDocument();
    }

    protected void extendSignatureTag() throws DSSException {
        this.assertExtendSignatureToTPossible();
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        this.ensureSignedDataObjectProperties();
        this.assertSignatureValid(this.xadesSignature);
        Element levelBUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        if (!this.xadesSignature.hasTProfile() || SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel())) {
            TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] canonicalisedValue = this.xadesSignature.getTimestampSource().getSignatureTimestampData(canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest(timestampDigestAlgorithm, canonicalisedValue);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, digestValue);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelBUnsignedProperties);
        }
    }

    private void assertExtendSignatureToTPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_T.equals((Object)signatureLevel) && (this.xadesSignature.hasLTProfile() || this.xadesSignature.hasLTAProfile())) {
            String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "XAdES LT"));
        }
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected Element incorporateCertificateValues(Element parentDom, ValidationContext validationContext) {
        Element certificateValuesDom = null;
        Set<CertificateToken> toIncludeCertificates = this.xadesSignature.getCertificatesForInclusion(validationContext);
        if (!toIncludeCertificates.isEmpty()) {
            HashSet<CertificateToken> certificatesToBeAdded = new HashSet<CertificateToken>();
            List<CertificateToken> signatureCertificates = this.xadesSignature.getCertificateSource().getCertificates();
            for (CertificateToken certificateToken : toIncludeCertificates) {
                if (signatureCertificates.contains(certificateToken)) continue;
                certificatesToBeAdded.add(certificateToken);
            }
            if (!certificatesToBeAdded.isEmpty()) {
                certificateValuesDom = DomUtils.addElement(this.documentDom, parentDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CertificateValues");
                for (CertificateToken certificateToken : certificatesToBeAdded) {
                    String base64EncodeCertificate = Utils.toBase64(certificateToken.getEncoded());
                    DomUtils.addTextElement(this.documentDom, certificateValuesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:EncapsulatedX509Certificate", base64EncodeCertificate);
                }
            }
        }
        return certificateValuesDom;
    }

    protected Element incorporateRevocationValues(Element parentDom, ValidationContext validationContext) {
        Element revocationValuesDom = null;
        DefaultAdvancedSignature.RevocationDataForInclusion revocationsForInclusion = this.xadesSignature.getRevocationDataForInclusion(validationContext);
        if (!revocationsForInclusion.isEmpty()) {
            List<RevocationToken> crlsToBeAdded = this.filterDuplicateRevocations(revocationsForInclusion.crlTokens, this.xadesSignature.getCRLSource().getCRLBinaryList());
            List<RevocationToken> ocspToBeAdded = this.filterDuplicateRevocations(revocationsForInclusion.ocspTokens, this.xadesSignature.getOCSPSource().getOCSPResponsesList());
            if (Utils.isCollectionNotEmpty(crlsToBeAdded) || Utils.isCollectionNotEmpty(ocspToBeAdded)) {
                revocationValuesDom = DomUtils.addElement(this.documentDom, parentDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:RevocationValues");
                this.incorporateCrlTokens(revocationValuesDom, crlsToBeAdded);
                this.incorporateOcspTokens(revocationValuesDom, ocspToBeAdded);
            }
        }
        return revocationValuesDom;
    }

    private List<RevocationToken> filterDuplicateRevocations(List<? extends RevocationToken> revocationTokens, Collection<? extends EncapsulatedRevocationTokenIdentifier> revocationBinaryList) {
        ArrayList<RevocationToken> revocationTokensToBeAdded = new ArrayList<RevocationToken>();
        for (RevocationToken revocationToken : revocationTokens) {
            boolean found = false;
            for (EncapsulatedRevocationTokenIdentifier encapsulatedRevocationTokenIdentifier : revocationBinaryList) {
                if (!Arrays.equals(revocationToken.getEncoded(), encapsulatedRevocationTokenIdentifier.getBinaries())) continue;
                found = true;
                break;
            }
            if (found) continue;
            revocationTokensToBeAdded.add(revocationToken);
        }
        return revocationTokensToBeAdded;
    }

    private void incorporateCrlTokens(Element parentDom, List<RevocationToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlValuesDom = DomUtils.addElement(this.documentDom, parentDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CRLValues");
        for (RevocationToken revocationToken : crlTokens) {
            byte[] encodedCRL = revocationToken.getEncoded();
            String base64EncodedCRL = Utils.toBase64(encodedCRL);
            DomUtils.addTextElement(this.documentDom, crlValuesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:EncapsulatedCRLValue", base64EncodedCRL);
        }
    }

    private void incorporateOcspTokens(Element parentDom, List<RevocationToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspValuesDom = DomUtils.addElement(this.documentDom, parentDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:OCSPValues");
        for (RevocationToken revocationToken : ocspTokens) {
            byte[] encodedOCSP = revocationToken.getEncoded();
            String base64EncodedOCSP = Utils.toBase64(encodedOCSP);
            DomUtils.addTextElement(this.documentDom, ocspValuesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:EncapsulatedOCSPValue", base64EncodedOCSP);
        }
    }

    protected void incorporateCertificateValues(Element parentDom, ValidationContext validationContext, String indent) {
        Element certificatesDom = this.incorporateCertificateValues(parentDom, validationContext);
        if (certificatesDom != null && indent != null) {
            DomUtils.setTextNode(this.documentDom, this.unsignedSignaturePropertiesDom, indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, certificatesDom);
        }
    }

    protected void incorporateRevocationValues(Element parentDom, ValidationContext validationContext, String indent) {
        Element revocationDom = this.incorporateRevocationValues(parentDom, validationContext);
        if (revocationDom != null && indent != null) {
            DomUtils.setTextNode(this.documentDom, this.unsignedSignaturePropertiesDom, indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, revocationDom);
        }
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, byte[] digestValue) throws DSSException {
        Element timeStampDom = null;
        TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
        DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignatureTimeStamp");
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                if (this.params.isEn319132() && !this.isOldGeneration(this.params.getSignatureLevel())) {
                    timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigAndRefsTimeStampV2");
                    break;
                }
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigAndRefsTimeStamp");
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, "http://uri.etsi.org/01903/v1.4.1#", "xades141:ArchiveTimeStamp");
                timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                break;
            }
            default: {
                throw new DSSException("Unsupported timestamp type : " + (Object)((Object)timestampType));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp generation: {} / {} / {}", timestampDigestAlgorithm.getName(), timestampC14nMethod, Utils.toBase64(digestValue));
        }
        TimeStampToken timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digestValue);
        String base64EncodedTimeStampToken = Utils.toBase64(DSSASN1Utils.getDEREncoded(timeStampToken));
        String timestampId = UUID.randomUUID().toString();
        timeStampDom.setAttribute("Id", "TS-" + timestampId);
        this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
        Element encapsulatedTimeStampDom = DomUtils.addElement(this.documentDom, timeStampDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:EncapsulatedTimeStamp");
        encapsulatedTimeStampDom.setAttribute("Id", "ETS-" + timestampId);
        DomUtils.setTextNode(this.documentDom, encapsulatedTimeStampDom, base64EncodedTimeStampToken);
    }

    private boolean isOldGeneration(SignatureLevel signatureLevel) {
        return SignatureLevel.XAdES_X.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel) || SignatureLevel.XAdES_A.equals((Object)signatureLevel);
    }
}

