/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExtensionBuilder
extends XAdESBuilder {
    protected XAdESSignature xadesSignature;
    protected Element currentSignatureDom;
    protected Element qualifyingPropertiesDom;
    protected Element unsignedPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedDataObjectPropertiesDom;

    protected ExtensionBuilder(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected void ensureUnsignedProperties() {
        NodeList qualifyingPropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_QUALIFYING_PROPERTIES);
        if (qualifyingPropertiesNodeList.getLength() != 1) {
            throw new DSSException("The signature does not contain QualifyingProperties element (or contains more than one)! Extension is not possible.");
        }
        this.qualifyingPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        NodeList unsignedPropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
        int length = unsignedPropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedPropertiesDom = DomUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:UnsignedProperties");
            if (this.params.isPrettyPrint()) {
                this.qualifyingPropertiesDom = (Element)DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
                this.unsignedPropertiesDom = (Element)DomUtils.getNode(this.currentSignatureDom, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
            }
        } else {
            throw new DSSException("The signature contains more then one UnsignedProperties element! Extension is not possible.");
        }
    }

    protected void ensureUnsignedSignatureProperties() {
        NodeList unsignedSignaturePropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
        int length = unsignedSignaturePropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedSignaturePropertiesDom = (Element)unsignedSignaturePropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedSignaturePropertiesDom = DomUtils.addElement(this.documentDom, this.unsignedPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:UnsignedSignatureProperties");
            if (this.params.isPrettyPrint()) {
                this.unsignedPropertiesDom = (Element)DSSXMLUtils.indentAndReplace(this.documentDom, this.unsignedPropertiesDom);
                this.unsignedSignaturePropertiesDom = (Element)DomUtils.getNode(this.currentSignatureDom, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
            }
        } else {
            throw new DSSException("The signature contains more then one UnsignedSignatureProperties element! Extension is not possible.");
        }
    }

    protected void ensureSignedDataObjectProperties() {
        NodeList signedDataObjectPropertiesNodeList = DomUtils.getNodeList(this.currentSignatureDom, this.xPathQueryHolder.XPATH_SIGNED_DATA_OBJECT_PROPERTIES);
        int length = signedDataObjectPropertiesNodeList.getLength();
        if (length == 1) {
            this.signedDataObjectPropertiesDom = (Element)signedDataObjectPropertiesNodeList.item(0);
        } else if (length > 1) {
            throw new DSSException("The signature contains more than one SignedDataObjectProperties element! Extension is not possible.");
        }
    }

    protected void assertSignatureValid(XAdESSignature xadesSignature) {
        SignatureCryptographicVerification signatureCryptographicVerification = xadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    protected Element indentIfPrettyPrint(Element nodeToIndent, Element oldNode) {
        if (this.params.isPrettyPrint()) {
            nodeToIndent = (Element)DSSXMLUtils.indentAndExtend(this.documentDom, nodeToIndent, oldNode);
        }
        return nodeToIndent;
    }

    @Override
    protected void alignNodes() {
        if (this.unsignedSignaturePropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.unsignedSignaturePropertiesDom);
        }
        if (this.qualifyingPropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
        }
    }

    protected String removeChild(Node parentNode, Node nodeToRemove) {
        String text = null;
        if (nodeToRemove != null) {
            Node nextSibling = nodeToRemove.getNextSibling();
            if (nextSibling != null && 3 == nextSibling.getNodeType()) {
                text = nextSibling.getNodeValue();
                this.unsignedSignaturePropertiesDom.removeChild(nextSibling);
            }
            this.unsignedSignaturePropertiesDom.removeChild(nodeToRemove);
        }
        return text;
    }
}

