/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DetachedSignatureBuilder
extends XAdESSignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetachedSignatureBuilder.class);

    public DetachedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
        this.setCanonicalizationMethods(params, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    @Override
    protected Document buildRootDocumentDom() {
        if (this.params.getRootDocument() != null) {
            return this.params.getRootDocument();
        }
        return DomUtils.buildDOM();
    }

    @Override
    protected Node getParentNodeOfSignature() {
        if (this.params.getRootDocument() != null) {
            return this.documentDom.getDocumentElement();
        }
        return this.documentDom;
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference reference = new DSSReference();
        reference.setId("r-" + this.deterministicId + "-" + referenceIndex);
        if (Utils.isStringNotEmpty(document.getName())) {
            String fileURI = document.getName();
            try {
                reference.setUri(URLEncoder.encode(fileURI, "UTF-8").replace("+", "%20"));
            }
            catch (Exception e) {
                LOG.warn("Unable to encode uri '{}' : {}", (Object)fileURI, (Object)e.getMessage());
                reference.setUri(fileURI);
            }
        }
        reference.setContents(document);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        reference.setDigestMethodAlgorithm(digestAlgorithm);
        return reference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        return reference.getContents();
    }
}

