/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.tsp.TimeStampToken;

public class AllDataObjectsTimeStampBuilder {
    private final TSPSource tspSource;
    private final TimestampParameters timestampParameters;

    public AllDataObjectsTimeStampBuilder(TSPSource tspSource, TimestampParameters timestampParameters) {
        this.tspSource = tspSource;
        this.timestampParameters = timestampParameters;
    }

    public TimestampToken build(DSSDocument document) {
        return this.build(Arrays.asList(document));
    }

    public TimestampToken build(List<DSSDocument> documents) {
        boolean canonicalizationUsed = false;
        byte[] dataToBeDigested = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (DSSDocument document : documents) {
                byte[] binaries = DSSUtils.toByteArray(document);
                if (Utils.isStringNotEmpty(this.timestampParameters.getCanonicalizationMethod()) && DomUtils.isDOM(binaries)) {
                    binaries = DSSXMLUtils.canonicalize(this.timestampParameters.getCanonicalizationMethod(), binaries);
                    canonicalizationUsed = true;
                }
                baos.write(binaries);
            }
            dataToBeDigested = baos.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Unable to compute the data to be digested", e);
        }
        byte[] digestToTimestamp = DSSUtils.digest(this.timestampParameters.getDigestAlgorithm(), dataToBeDigested);
        TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(this.timestampParameters.getDigestAlgorithm(), digestToTimestamp);
        TimestampToken token = new TimestampToken(timeStampResponse, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
        if (canonicalizationUsed) {
            token.setCanonicalizationMethod(this.timestampParameters.getCanonicalizationMethod());
        }
        return token;
    }
}

