/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESReferenceValidation
extends ReferenceValidation {
    private static final long serialVersionUID = 2721340360134442005L;
    private static final Logger LOG = LoggerFactory.getLogger(XAdESReferenceValidation.class);
    private static final Map<String, String> presentableTransformationNames = new HashMap<String, String>();
    private final Reference reference;
    private final String id;
    private final String uri;

    public XAdESReferenceValidation(Reference reference) {
        this.reference = reference;
        this.id = reference.getId();
        this.uri = this.extractUri(reference);
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUriOrEmpty() {
        return this.uri != null ? this.uri : "";
    }

    private String extractUri(Reference reference) {
        Element element;
        if (reference != null && (element = reference.getElement()) != null) {
            return DSSXMLUtils.getAttribute(element, "uri");
        }
        return null;
    }

    public byte[] getOriginalContentBytes() {
        return DSSXMLUtils.getReferenceOriginalContentBytes(this.reference);
    }

    @Override
    public String getName() {
        if (Utils.isStringNotBlank(this.id)) {
            return this.id;
        }
        if (Utils.isStringNotBlank(this.uri)) {
            return this.uri;
        }
        return "";
    }

    @Override
    public List<String> getTransformationNames() {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
            try {
                Element transformsElement;
                NodeList transfromChildNodes;
                Transforms referenceTransforms = this.reference.getTransforms();
                if (referenceTransforms != null && (transfromChildNodes = (transformsElement = referenceTransforms.getElement()).getChildNodes()) != null && transfromChildNodes.getLength() > 0) {
                    for (int i = 0; i < transfromChildNodes.getLength(); ++i) {
                        Node transformation = transfromChildNodes.item(i);
                        if (1 != transformation.getNodeType()) continue;
                        this.transforms.add(this.buildTransformationName(transformation));
                    }
                }
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to analyze trasnformations", e);
            }
        }
        return this.transforms;
    }

    private String buildTransformationName(Node transformation) {
        String algorithm = DomUtils.getValue(transformation, "@Algorithm");
        if (presentableTransformationNames.containsKey(algorithm)) {
            algorithm = presentableTransformationNames.get(algorithm);
        }
        StringBuilder stringBuilder = new StringBuilder(algorithm);
        if (transformation.hasChildNodes()) {
            NodeList childNodes = transformation.getChildNodes();
            stringBuilder.append(" (");
            boolean hasValues = false;
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node parameterValueNode;
                Node parameterNode = childNodes.item(j);
                if (1 != parameterNode.getNodeType() || (parameterValueNode = parameterNode.getFirstChild()) == null || 3 != parameterValueNode.getNodeType() || !Utils.isStringNotBlank(parameterValueNode.getTextContent())) continue;
                if (hasValues) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(parameterNode.getLocalName()).append(": ");
                stringBuilder.append(parameterValueNode.getTextContent());
                hasValues = true;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    static {
        presentableTransformationNames.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", "Enveloped Signature Transform");
        presentableTransformationNames.put("http://www.w3.org/2000/09/xmldsig#base64", "Base64 Decoding");
        presentableTransformationNames.put("http://www.w3.org/2002/06/xmldsig-filter2", "XPath filtering");
        presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "XPath filtering");
        presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "XSLT Transform");
        presentableTransformationNames.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "Canonical XML 1.0 with Comments");
        presentableTransformationNames.put("http://www.w3.org/2006/12/xml-c14n11#WithComments", "Canonical XML 1.1 with Comments");
        presentableTransformationNames.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "Exclusive XML Canonicalization 1.0 with Comments");
        presentableTransformationNames.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "Canonical XML 1.0 (omits comments)");
        presentableTransformationNames.put("http://www.w3.org/2006/12/xml-c14n11", "Canonical XML 1.1 (omits comments)");
        presentableTransformationNames.put("http://www.w3.org/2001/10/xml-exc-c14n#", "Exclusive Canonical XML (omits comments)");
    }
}

