/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import java.util.List;
import org.w3c.dom.Document;

public class XAdESSignatureParameters
extends AbstractSignatureParameters {
    private ProfileParameters context;
    private boolean addX509SubjectName;
    private List<DSSReference> dssReferences;
    private boolean embedXML;
    private boolean en319132 = true;
    private String keyInfoCanonicalizationMethod;
    private boolean manifestSignature;
    private Document rootDocument;
    private byte[] signedAdESObject;
    private DigestAlgorithm signingCertificateDigestMethod = DigestAlgorithm.SHA512;
    private String signedInfoCanonicalizationMethod;
    private boolean signKeyInfo = false;
    private String signedPropertiesCanonicalizationMethod;
    private String xPathLocationString;
    private boolean prettyPrint = false;

    @Override
    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.XAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only XAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    public void setSigningCertificateDigestMethod(DigestAlgorithm signingCertificateDigestMethod) {
        this.signingCertificateDigestMethod = signingCertificateDigestMethod;
    }

    public DigestAlgorithm getSigningCertificateDigestMethod() {
        return this.signingCertificateDigestMethod;
    }

    public String getSignedInfoCanonicalizationMethod() {
        return this.signedInfoCanonicalizationMethod;
    }

    public void setSignedInfoCanonicalizationMethod(String signedInfoCanonicalizationMethod) {
        this.signedInfoCanonicalizationMethod = signedInfoCanonicalizationMethod;
    }

    public String getSignedPropertiesCanonicalizationMethod() {
        return this.signedPropertiesCanonicalizationMethod;
    }

    public void setSignedPropertiesCanonicalizationMethod(String signedPropertiesCanonicalizationMethod) {
        this.signedPropertiesCanonicalizationMethod = signedPropertiesCanonicalizationMethod;
    }

    public String getKeyInfoCanonicalizationMethod() {
        return this.keyInfoCanonicalizationMethod;
    }

    public void setKeyInfoCanonicalizationMethod(String keyInfoCanonicalizationMethod) {
        this.keyInfoCanonicalizationMethod = keyInfoCanonicalizationMethod;
    }

    public boolean isSignKeyInfo() {
        return this.signKeyInfo;
    }

    public void setSignKeyInfo(boolean signKeyInfo) {
        this.signKeyInfo = signKeyInfo;
    }

    public List<DSSReference> getReferences() {
        return this.dssReferences;
    }

    public void setReferences(List<DSSReference> references) {
        this.dssReferences = references;
    }

    public String getXPathLocationString() {
        return this.xPathLocationString;
    }

    public void setXPathLocationString(String xPathLocationString) {
        this.xPathLocationString = xPathLocationString;
    }

    public Document getRootDocument() {
        return this.rootDocument;
    }

    public void setRootDocument(Document rootDocument) {
        this.rootDocument = rootDocument;
    }

    public ProfileParameters getContext() {
        if (this.context == null) {
            this.context = new ProfileParameters();
        }
        return this.context;
    }

    public boolean isEn319132() {
        return this.en319132;
    }

    public void setEn319132(boolean en319132) {
        this.en319132 = en319132;
    }

    public boolean isEmbedXML() {
        return this.embedXML;
    }

    public void setEmbedXML(boolean embedXML) {
        this.embedXML = embedXML;
    }

    public boolean isManifestSignature() {
        return this.manifestSignature;
    }

    public void setManifestSignature(boolean manifestSignature) {
        this.manifestSignature = manifestSignature;
    }

    public boolean isAddX509SubjectName() {
        return this.addX509SubjectName;
    }

    public void setAddX509SubjectName(boolean addX509SubjectName) {
        this.addX509SubjectName = addX509SubjectName;
    }

    public byte[] getSignedAdESObject() {
        return this.signedAdESObject;
    }

    public void setSignedAdESObject(byte[] signedAdESObject) {
        this.signedAdESObject = signedAdESObject;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }
}

