/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.dto.parameters;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import java.io.Serializable;

public class RemoteTimestampParameters
implements Serializable {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public RemoteTimestampParameters() {
    }

    public RemoteTimestampParameters(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.canonicalizationMethod = null;
    }

    public RemoteTimestampParameters(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        this.digestAlgorithm = digestAlgorithm;
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm == null) {
            throw new NullPointerException();
        }
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalizationMethod == null ? 0 : this.canonicalizationMethod.hashCode());
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteTimestampParameters other = (RemoteTimestampParameters)obj;
        if (this.canonicalizationMethod == null ? other.canonicalizationMethod != null : !this.canonicalizationMethod.equals(other.canonicalizationMethod)) {
            return false;
        }
        return this.digestAlgorithm == other.digestAlgorithm;
    }

    public String toString() {
        return "RemoteTimestampParameters{, digestAlgorithm=" + this.digestAlgorithm.getName() + ", canonicalizationMethod=" + this.canonicalizationMethod + "}";
    }
}

