/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteMultipleDocumentsSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMultipleDocumentsSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteMultipleDocumentsSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMultipleDocumentsSignatureServiceImpl.class);
    private MultipleDocumentsSignatureService<XAdESSignatureParameters> xadesService;
    private MultipleDocumentsSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService;
    private MultipleDocumentsSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService;

    public void setXadesService(MultipleDocumentsSignatureService<XAdESSignatureParameters> xadesService) {
        this.xadesService = xadesService;
    }

    public void setAsicWithCAdESService(MultipleDocumentsSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    public void setAsicWithXAdESService(MultipleDocumentsSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    @Override
    public ToBeSignedDTO getDataToSign(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters) {
        LOG.info("GetDataToSign in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters);
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toSignDocuments);
        ToBeSigned dataToSign = service.getDataToSign(dssDocuments, parameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO(dataToSign);
    }

    @Override
    public RemoteDocument signDocument(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        LOG.info("SignDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters);
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toSignDocuments);
        DSSDocument signDocument = service.signDocument(dssDocuments, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(signDocument);
    }

    @Override
    public RemoteDocument extendDocument(RemoteDocument toExtendDocument, RemoteSignatureParameters remoteParameters) {
        LOG.info("ExtendDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters);
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(toExtendDocument);
        DSSDocument extendDocument = service.extendDocument(dssDocument, parameters);
        LOG.info("ExtendDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(extendDocument);
    }

    private MultipleDocumentsSignatureService getServiceForSignature(RemoteSignatureParameters parameters) {
        ASiCContainerType asicContainerType = parameters.getAsicContainerType();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        SignatureForm signatureForm = signatureLevel.getSignatureForm();
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + (Object)((Object)signatureForm));
        }
        if (SignatureForm.XAdES == signatureForm) {
            return this.xadesService;
        }
        throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC or XAdES) : " + (Object)((Object)signatureForm));
    }
}

