/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCertificateSource;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampToken
extends Token {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampToken.class);
    private final TimeStampToken timeStamp;
    private final TimestampType timeStampType;
    private final TimestampCertificateSource certificateSource;
    private final TimestampCRLSource crlSource;
    private final TimestampOCSPSource ocspSource;
    private final List<TimestampedReference> timestampedReferences;
    private boolean processed = false;
    private boolean messageImprintData;
    private Boolean messageImprintIntact = null;
    private TimestampLocation timeStampLocation;
    private List<TimestampInclude> timestampIncludes;
    private ArchiveTimestampType archiveTimestampType;
    private String canonicalizationMethod;
    private X500Principal tsaX500Principal;
    private int hashCode;

    public TimestampToken(byte[] binaries, TimestampType type) throws TSPException, IOException, CMSException {
        this(binaries, type, new CertificatePool());
    }

    public TimestampToken(byte[] binaries, TimestampType type, CertificatePool certPool) throws TSPException, IOException, CMSException {
        this(binaries, type, certPool, null);
    }

    public TimestampToken(byte[] binaries, TimestampType type, CertificatePool certPool, TimestampLocation timeStampLocation) throws TSPException, IOException, CMSException {
        this(binaries, type, certPool, new ArrayList<TimestampedReference>(), timeStampLocation);
    }

    public TimestampToken(byte[] binaries, TimestampType type, CertificatePool certPool, List<TimestampedReference> timestampedReferences, TimestampLocation timeStampLocation) throws TSPException, IOException, CMSException {
        this(new CMSSignedData(binaries), type, certPool, timestampedReferences, timeStampLocation);
    }

    public TimestampToken(CMSSignedData cms, TimestampType type, CertificatePool certPool) throws TSPException, IOException {
        this(cms, type, certPool, null);
    }

    public TimestampToken(CMSSignedData cms, TimestampType type, CertificatePool certPool, TimestampLocation timeStampLocation) throws TSPException, IOException {
        this(new TimeStampToken(cms), type, certPool, timeStampLocation);
    }

    public TimestampToken(CMSSignedData cms, TimestampType type, CertificatePool certPool, List<TimestampedReference> timestampedReferences, TimestampLocation timeStampLocation) throws TSPException, IOException {
        this(new TimeStampToken(cms), type, certPool, timestampedReferences, timeStampLocation);
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type) {
        this(timeStamp, type, new CertificatePool());
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type, CertificatePool certPool) {
        this(timeStamp, type, certPool, null);
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type, CertificatePool certPool, TimestampLocation timeStampLocation) {
        this(timeStamp, type, certPool, new ArrayList<TimestampedReference>(), timeStampLocation);
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type, CertificatePool certPool, List<TimestampedReference> timestampedReferences, TimestampLocation timeStampLocation) {
        this(timeStamp, type, new TimestampCertificateSource(timeStamp, certPool), new TimestampCRLSource(timeStamp), new TimestampOCSPSource(timeStamp), timestampedReferences, timeStampLocation);
    }

    public TimestampToken(TimestampToken timestampToken) {
        this(timestampToken.timeStamp, timestampToken.timeStampType, timestampToken.certificateSource, timestampToken.crlSource, timestampToken.ocspSource, new ArrayList<TimestampedReference>(timestampToken.timestampedReferences), timestampToken.timeStampLocation);
    }

    TimestampToken(TimeStampToken timeStamp, TimestampType type, TimestampCertificateSource certificateSource, TimestampCRLSource crlSource, TimestampOCSPSource ocspSource, List<TimestampedReference> timestampedReferences, TimestampLocation timeStampLocation) {
        this.timeStamp = timeStamp;
        this.timeStampType = type;
        this.certificateSource = certificateSource;
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
        this.timestampedReferences = timestampedReferences;
        if (timeStampLocation != null) {
            this.timeStampLocation = timeStampLocation;
        }
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.tsaX500Principal;
    }

    @Override
    public String getAbbreviation() {
        return this.timeStampType.name() + ": " + this.getDSSIdAsString() + ": " + DSSUtils.formatInternal(this.timeStamp.getTimeStampInfo().getGenTime());
    }

    public TimestampCRLSource getCRLSource() {
        return this.crlSource;
    }

    public TimestampOCSPSource getOCSPSource() {
        return this.ocspSource;
    }

    @Override
    protected boolean checkIsSignedBy(CertificateToken candidate) {
        X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(candidate);
        if (this.timeStamp.getSID().match(x509CertificateHolder)) {
            SignerInformationVerifier signerInformationVerifier = this.getSignerInformationVerifier(candidate);
            if (this.isValidTimestamp(signerInformationVerifier) || this.isValidCMSSignedData(signerInformationVerifier)) {
                this.signatureValid = true;
                this.tsaX500Principal = candidate.getSubjectX500Principal();
                SignerInformation signerInformation = this.timeStamp.toCMSSignedData().getSignerInfos().get(this.timeStamp.getSID());
                if (SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.getOid().equals(signerInformation.getEncryptionAlgOID())) {
                    this.signatureAlgorithm = SignatureAlgorithm.forOidAndParams(signerInformation.getEncryptionAlgOID(), signerInformation.getEncryptionAlgParams());
                } else {
                    EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.forName(candidate.getPublicKey().getAlgorithm());
                    AlgorithmIdentifier hashAlgorithm = signerInformation.getDigestAlgorithmID();
                    DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(hashAlgorithm.getAlgorithm().getId());
                    this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
                }
            } else {
                this.signatureValid = false;
            }
            return this.signatureValid;
        }
        return false;
    }

    private boolean isValidTimestamp(SignerInformationVerifier signerInformationVerifier) {
        try {
            this.timeStamp.validate(signerInformationVerifier);
            return true;
        }
        catch (TSPException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to validate timestamp token : ", e);
            } else {
                LOG.warn("Unable to validate timestamp token : {}", (Object)e.getMessage());
            }
            this.signatureInvalidityReason = e.getClass().getSimpleName() + " : " + e.getMessage();
            return false;
        }
    }

    private boolean isValidCMSSignedData(SignerInformationVerifier signerInformationVerifier) {
        try {
            SignerInformationStore signerInfos = this.timeStamp.toCMSSignedData().getSignerInfos();
            SignerInformation signerInformation = signerInfos.get(this.timeStamp.getSID());
            return signerInformation.verify(signerInformationVerifier);
        }
        catch (CMSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to validate the related CMSSignedData : ", e);
            } else {
                LOG.warn("Unable to validate the related CMSSignedData : {}", (Object)e.getMessage());
            }
            this.signatureInvalidityReason = e.getClass().getSimpleName() + " : " + e.getMessage();
            return false;
        }
    }

    private SignerInformationVerifier getSignerInformationVerifier(CertificateToken candidate) {
        try {
            JcaSimpleSignerInfoVerifierBuilder verifier = new JcaSimpleSignerInfoVerifierBuilder();
            verifier.setProvider(DSSSecurityProvider.getSecurityProviderName());
            return verifier.build(candidate.getCertificate());
        }
        catch (OperatorException e) {
            throw new DSSException("Unable to build an instance of SignerInformationVerifier", e);
        }
    }

    public boolean matchData(byte[] data) {
        return this.matchData(data, false);
    }

    public boolean matchData(byte[] data, boolean suppressMatchWarnings) {
        this.processed = true;
        this.messageImprintData = data != null;
        this.messageImprintIntact = false;
        if (this.messageImprintData) {
            try {
                TimeStampTokenInfo timeStampInfo = this.timeStamp.getTimeStampInfo();
                ASN1ObjectIdentifier hashAlgorithm = timeStampInfo.getMessageImprintAlgOID();
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(hashAlgorithm.getId());
                byte[] computedDigest = DSSUtils.digest(digestAlgorithm, data);
                byte[] timestampDigest = timeStampInfo.getMessageImprintDigest();
                this.messageImprintIntact = Arrays.equals(computedDigest, timestampDigest);
                if (!this.messageImprintIntact.booleanValue() && !suppressMatchWarnings) {
                    LOG.warn("Computed digest ({}) on the extracted data from the document : {}", (Object)digestAlgorithm, (Object)Utils.toHex(computedDigest));
                    LOG.warn("Digest present in TimestampToken: {}", (Object)Utils.toHex(timestampDigest));
                    LOG.warn("Digest in TimestampToken matches digest of extracted data from document: {}", (Object)this.messageImprintIntact);
                }
            }
            catch (DSSException e) {
                LOG.warn("Unable to validate the timestamp", e);
            }
        } else {
            LOG.warn("Timestamped data not found !");
        }
        return this.messageImprintIntact;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public TimestampType getTimeStampType() {
        return this.timeStampType;
    }

    public TimestampLocation getTimestampLocation() {
        return this.timeStampLocation;
    }

    public Date getGenerationTime() {
        return this.timeStamp.getTimeStampInfo().getGenTime();
    }

    @Override
    public Date getCreationDate() {
        return this.getGenerationTime();
    }

    public DigestAlgorithm getSignedDataDigestAlgo() {
        ASN1ObjectIdentifier oid = this.timeStamp.getTimeStampInfo().getMessageImprintAlgOID();
        return DigestAlgorithm.forOID(oid.getId());
    }

    public byte[] getMessageImprintDigest() {
        return this.timeStamp.getTimeStampInfo().getMessageImprintDigest();
    }

    public Boolean isMessageImprintDataFound() {
        return this.messageImprintData;
    }

    public Boolean isMessageImprintDataIntact() {
        if (this.messageImprintIntact == null) {
            throw new DSSException("Invoke matchData(byte[] data) method before!");
        }
        return this.messageImprintIntact;
    }

    public List<TimestampedReference> getTimestampedReferences() {
        return this.timestampedReferences;
    }

    public ArchiveTimestampType getArchiveTimestampType() {
        return this.archiveTimestampType;
    }

    public void setArchiveTimestampType(ArchiveTimestampType archiveTimestampType) {
        this.archiveTimestampType = archiveTimestampType;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    @Override
    public byte[] getEncoded() {
        return DSSASN1Utils.getDEREncoded(this.timeStamp);
    }

    public List<TimestampInclude> getTimestampIncludes() {
        return this.timestampIncludes;
    }

    public void setTimestampIncludes(List<TimestampInclude> timestampIncludes) {
        this.timestampIncludes = timestampIncludes;
    }

    public List<CertificateToken> getCertificates() {
        return this.certificateSource.getCertificates();
    }

    public List<CertificateRef> getCertificateRefs() {
        return this.certificateSource.getAllCertificateRefs();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.timeStamp.getUnsignedAttributes();
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    @Override
    public String toString(String indentStr) {
        try {
            StringBuilder out = new StringBuilder();
            out.append(indentStr).append("TimestampToken[signedBy=").append(this.getIssuerX500Principal());
            out.append(", generated: ").append(DSSUtils.formatInternal(this.timeStamp.getTimeStampInfo().getGenTime()));
            out.append(" / ").append((Object)this.timeStampType).append('\n');
            if (this.signatureValid) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: VALID").append('\n');
                indentStr = indentStr.substring(1);
            } else if (!this.signatureInvalidityReason.isEmpty()) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: INVALID").append(" - ").append(this.signatureInvalidityReason).append('\n');
                indentStr = indentStr.substring(1);
            }
            indentStr = indentStr + "\t";
            if (this.messageImprintIntact != null) {
                if (this.messageImprintIntact.booleanValue()) {
                    out.append(indentStr).append("Timestamp MATCHES the signed data.").append('\n');
                } else {
                    out.append(indentStr).append("Timestamp DOES NOT MATCH the signed data.").append('\n');
                }
            }
            out.append(']');
            return out.toString();
        }
        catch (Exception e) {
            return this.getClass().getName();
        }
    }

    public SignerId getSignerId() {
        return this.timeStamp.getSID();
    }

    @Override
    public String getDSSIdAsString() {
        return "T-" + super.getDSSIdAsString();
    }
}

