/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;

public class TimestampBasicBuildingBlocksCheck
extends ChainItem<XmlValidationProcessTimestamps> {
    private final XmlBasicBuildingBlocks timestampBBB;
    private Indication indication;
    private SubIndication subIndication;

    public TimestampBasicBuildingBlocksCheck(XmlValidationProcessTimestamps result, XmlBasicBuildingBlocks timestampBBB, LevelConstraint constraint) {
        super(result, constraint, timestampBBB.getId());
        this.timestampBBB = timestampBBB;
    }

    @Override
    protected boolean process() {
        XmlConclusion savConclusion;
        XmlConclusion xcvConclusion;
        XmlConclusion cvConclusion;
        XmlConclusion iscConclusion;
        XmlISC isc = this.timestampBBB.getISC();
        if (isc != null && !Indication.PASSED.equals((iscConclusion = isc.getConclusion()).getIndication())) {
            this.indication = iscConclusion.getIndication();
            this.subIndication = iscConclusion.getSubIndication();
            return false;
        }
        XmlCV cv = this.timestampBBB.getCV();
        if (cv != null && !Indication.PASSED.equals((cvConclusion = cv.getConclusion()).getIndication())) {
            this.indication = cvConclusion.getIndication();
            this.subIndication = cvConclusion.getSubIndication();
            return false;
        }
        XmlXCV xcv = this.timestampBBB.getXCV();
        if (xcv != null && !Indication.PASSED.equals((xcvConclusion = xcv.getConclusion()).getIndication())) {
            this.indication = xcvConclusion.getIndication();
            this.subIndication = xcvConclusion.getSubIndication();
            return false;
        }
        XmlSAV sav = this.timestampBBB.getSAV();
        if (sav != null && !Indication.PASSED.equals((savConclusion = sav.getConclusion()).getIndication())) {
            this.indication = savConclusion.getIndication();
            this.subIndication = savConclusion.getSubIndication();
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_ROTVPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_ROTVPIIC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }
}

