/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.Date;

public class BestSignatureTimeNotBeforeCertificateIssuanceCheck
extends ChainItem<XmlPSV> {
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;

    public BestSignatureTimeNotBeforeCertificateIssuanceCheck(XmlPSV result, Date bestSignatureTime, CertificateWrapper signingCertificate, LevelConstraint constraint) {
        super(result, constraint);
        this.bestSignatureTime = bestSignatureTime;
        this.signingCertificate = signingCertificate;
    }

    @Override
    protected boolean process() {
        return !this.bestSignatureTime.before(this.signingCertificate.getNotBefore());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NOT_YET_VALID;
    }
}

