/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicRevocationsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.PastCertificateValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.CurrentTimeIndicationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastCertificateValidationAcceptableCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PastSignatureValidation
extends Chain<XmlPSV> {
    private final TokenProxy token;
    private final DiagnosticData diagnosticData;
    private final XmlBasicBuildingBlocks bbb;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;

    public PastSignatureValidation(TokenProxy token, DiagnosticData diagnosticData, XmlBasicBuildingBlocks bbb, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(new XmlPSV());
        ((XmlPSV)this.result).setTitle(BasicBuildingBlockDefinition.PAST_SIGNATURE_VALIDATION.getTitle());
        this.token = token;
        this.diagnosticData = diagnosticData;
        this.bbb = bbb;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected void initChain() {
        Indication currentTimeIndication = this.bbb.getConclusion().getIndication();
        SubIndication currentTimeSubIndication = this.bbb.getConclusion().getSubIndication();
        List<XmlName> currentTimeErrors = this.bbb.getConclusion().getErrors();
        PastCertificateValidation pcv = new PastCertificateValidation(this.token, this.diagnosticData, this.bbb, this.poe, this.currentTime, this.policy, this.context);
        XmlPCV pcvResult = (XmlPCV)pcv.execute();
        this.bbb.setPCV(pcvResult);
        ChainItem<XmlPSV> item = this.firstItem = this.pastCertificateValidationAcceptableCheck(pcvResult);
        Date controlTime = pcvResult.getControlTime();
        if (controlTime != null && this.poe.isPOEExists(this.token.getId(), controlTime)) {
            ((XmlPSV)this.result).setControlTime(controlTime);
            if (Indication.INDETERMINATE.equals(currentTimeIndication) && (SubIndication.REVOKED_NO_POE.equals(currentTimeSubIndication) || SubIndication.REVOKED_CA_NO_POE.equals(currentTimeSubIndication))) {
                item = item.setNextItem(this.poeExist());
                return;
            }
            if (Indication.INDETERMINATE.equals(currentTimeIndication) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals(currentTimeSubIndication)) {
                Date bestSignatureTime = this.poe.getLowestPOETime(this.token.getId(), controlTime);
                CertificateWrapper signingCertificate = this.token.getSigningCertificate();
                item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
                item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate));
                return;
            }
        }
        if (Indication.INDETERMINATE.equals(currentTimeIndication) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(currentTimeSubIndication)) {
            Date bestSignatureTime = this.poe.getLowestPOETime(this.token.getId(), controlTime);
            item = item.setNextItem(this.poeUsedAlgorithmInSecureTimeExistsForEachAlgorithmConcernedByFailure(this.token, bestSignatureTime, this.context));
            CertificateWrapper signingCertificate = this.token.getSigningCertificate();
            for (CertificateWrapper certificate : this.token.getCertificateChain()) {
                if (certificate.isTrusted()) break;
                SubContext subContext = SubContext.CA_CERTIFICATE;
                if (certificate.getId().equals(signingCertificate.getId())) {
                    subContext = SubContext.SIGNING_CERT;
                }
                bestSignatureTime = this.poe.getLowestPOETime(certificate.getId(), controlTime);
                item = item.setNextItem(this.poeUsedAlgorithmInSecureTimeExistsForEachAlgorithmConcernedByFailure(certificate, bestSignatureTime, this.context, subContext));
                List<CryptographicCheck<XmlPSV>> revocationCryptographicChecks = this.getRevocationCryptographicChecks(certificate.getCertificateRevocationData(), controlTime);
                item = item.setNextItem(this.certificateRevocationCryptographicCheck(revocationCryptographicChecks, certificate));
            }
            return;
        }
        item = item.setNextItem(this.currentTimeIndicationCheck(currentTimeIndication, currentTimeSubIndication, currentTimeErrors));
    }

    private ChainItem<XmlPSV> currentTimeIndicationCheck(Indication currentTimeIndication, SubIndication currentTimeSubIndication, List<XmlName> currentTimeErrors) {
        return new CurrentTimeIndicationCheck((XmlPSV)this.result, currentTimeIndication, currentTimeSubIndication, currentTimeErrors, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck(XmlPCV pcvResult) {
        return new PastCertificateValidationAcceptableCheck((XmlPSV)this.result, pcvResult, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExist() {
        return new POEExistsCheck((XmlPSV)this.result, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck((XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck((XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private CryptographicCheck<XmlPSV> poeUsedAlgorithmInSecureTimeExistsForEachAlgorithmConcernedByFailure(TokenProxy currentToken, Date bestSignatureTime, Context context) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(context);
        return new CryptographicCheck<XmlPSV>((XmlPSV)this.result, currentToken, bestSignatureTime, cryptographicConstraint);
    }

    private ChainItem<XmlPSV> poeUsedAlgorithmInSecureTimeExistsForEachAlgorithmConcernedByFailure(TokenProxy currentToken, Date bestSignatureTime, Context context, SubContext subContext) {
        CryptographicConstraint cryptographicConstraint = this.policy.getCertificateCryptographicConstraint(context, subContext);
        return new CryptographicCheck<XmlPSV>((XmlPSV)this.result, currentToken, bestSignatureTime, cryptographicConstraint);
    }

    private List<CryptographicCheck<XmlPSV>> getRevocationCryptographicChecks(List<CertificateRevocationWrapper> revocations, Date controlTime) {
        ArrayList<CryptographicCheck<XmlPSV>> revocationCryptographicChecks = new ArrayList<CryptographicCheck<XmlPSV>>();
        for (RevocationWrapper revocationWrapper : revocations) {
            Date bestSignatureTime = this.poe.getLowestPOETime(revocationWrapper.getId(), controlTime);
            revocationCryptographicChecks.add(this.poeUsedAlgorithmInSecureTimeExistsForEachAlgorithmConcernedByFailure(revocationWrapper, bestSignatureTime, Context.REVOCATION));
        }
        return revocationCryptographicChecks;
    }

    private ChainItem<XmlPSV> certificateRevocationCryptographicCheck(List<CryptographicCheck<XmlPSV>> revocationsChecks, CertificateWrapper certificate) {
        return new CryptographicRevocationsCheck<XmlPSV>((XmlPSV)this.result, revocationsChecks, certificate.getId());
    }
}

