/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class LongTermValidationCheck
extends ChainItem<XmlValidationProcessArchivalData> {
    private final XmlConstraintsConclusion longTermValidationResult;
    private Indication ltvIndication;
    private SubIndication ltvSubIndication;
    private List<XmlName> ltvErrors;

    public LongTermValidationCheck(XmlValidationProcessArchivalData result, XmlConstraintsConclusion longTermValidationResult, LevelConstraint constraint) {
        super(result, constraint);
        this.longTermValidationResult = longTermValidationResult;
    }

    @Override
    protected boolean process() {
        if (this.longTermValidationResult != null && this.longTermValidationResult.getConclusion() != null) {
            this.ltvIndication = this.longTermValidationResult.getConclusion().getIndication();
            this.ltvSubIndication = this.longTermValidationResult.getConclusion().getSubIndication();
            this.ltvErrors = this.longTermValidationResult.getConclusion().getErrors();
            return Indication.PASSED.equals(this.ltvIndication) || Indication.INDETERMINATE.equals(this.ltvIndication) && (SubIndication.REVOKED_NO_POE.equals(this.ltvSubIndication) || SubIndication.REVOKED_CA_NO_POE.equals(this.ltvSubIndication) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(this.ltvSubIndication) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(this.ltvSubIndication));
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_LTVV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_LTVV_ANS;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.ltvErrors;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ltvIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ltvSubIndication;
    }
}

