/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class POEExtraction {
    private Map<String, List<XmlProofOfExistence>> poe = new HashMap<String, List<XmlProofOfExistence>>();

    public void init(DiagnosticData diagnosticData, XmlProofOfExistence proofOfExistence) {
        Set<SignatureWrapper> signatures = diagnosticData.getAllSignatures();
        for (SignatureWrapper signatureWrapper : signatures) {
            this.addPOE(signatureWrapper.getId(), proofOfExistence);
        }
        Set<TimestampWrapper> timestamps = diagnosticData.getTimestampSet();
        for (TimestampWrapper timestamp : timestamps) {
            this.addPOE(timestamp.getId(), proofOfExistence);
        }
        List<CertificateWrapper> list = diagnosticData.getUsedCertificates();
        for (CertificateWrapper certificate : list) {
            this.addPOE(certificate.getId(), proofOfExistence);
            List<CertificateRevocationWrapper> revocations = certificate.getCertificateRevocationData();
            if (!Utils.isCollectionNotEmpty(revocations)) continue;
            for (CertificateRevocationWrapper revocation : revocations) {
                this.addPOE(revocation.getId(), proofOfExistence);
            }
        }
    }

    public void collectAllPOE(DiagnosticData diagnosticData) {
        for (TimestampWrapper timestamp : diagnosticData.getTimestampSet()) {
            this.extractPOE(timestamp);
        }
    }

    public void extractPOE(TimestampWrapper timestamp) {
        List<XmlTimestampedObject> timestampedObjects = timestamp.getTimestampedObjects();
        if (Utils.isCollectionNotEmpty(timestampedObjects)) {
            XmlProofOfExistence poe = new XmlProofOfExistence();
            poe.setTimestampId(timestamp.getId());
            poe.setTime(timestamp.getProductionTime());
            for (XmlTimestampedObject xmlTimestampedObject : timestampedObjects) {
                this.addPOE(xmlTimestampedObject.getToken().getId(), poe);
            }
        }
    }

    private void addPOE(String tokenId, XmlProofOfExistence proofOfExistence) {
        if (proofOfExistence != null) {
            List<XmlProofOfExistence> poesById = this.poe.get(tokenId);
            if (poesById == null) {
                poesById = new ArrayList<XmlProofOfExistence>();
                this.poe.put(tokenId, poesById);
            }
            poesById.add(proofOfExistence);
        }
    }

    public void addSignaturePOE(SignatureWrapper signature, XmlProofOfExistence proofOfExistence) {
        if (signature != null) {
            this.addPOE(signature.getId(), proofOfExistence);
        }
    }

    public boolean isPOEExists(String tokenId, Date controlTime) {
        List<XmlProofOfExistence> poes = this.poe.get(tokenId);
        if (poes != null) {
            for (XmlProofOfExistence poe : poes) {
                if (poe.getTime().compareTo(controlTime) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public Date getLowestPOETime(String tokenId, Date controlTime) {
        return this.getLowestPOE(tokenId, controlTime).getTime();
    }

    public XmlProofOfExistence getLowestPOE(String tokenId, Date controlTime) {
        XmlProofOfExistence lowestPOE = new XmlProofOfExistence();
        lowestPOE.setTime(controlTime);
        List<XmlProofOfExistence> poes = this.poe.get(tokenId);
        if (poes != null) {
            for (XmlProofOfExistence poe : poes) {
                if (poe.getTime().compareTo(lowestPOE.getTime()) > 0) continue;
                lowestPOE = poe;
            }
        }
        return lowestPOE;
    }
}

