/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.Date;
import java.util.List;

public class TimestampCoherenceOrderCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final List<TimestampWrapper> timestamps;

    public TimestampCoherenceOrderCheck(XmlValidationProcessLongTermData result, List<TimestampWrapper> timestamps, LevelConstraint constraint) {
        super(result, constraint);
        this.timestamps = timestamps;
    }

    @Override
    protected boolean process() {
        if (Utils.collectionSize(this.timestamps) <= 1) {
            return true;
        }
        Date latestContent = this.getLatestTimestampProductionDate(this.timestamps, TimestampType.getContentTimestampTypes());
        Date earliestSignature = this.getEarliestTimestampProductionTime(this.timestamps, TimestampType.SIGNATURE_TIMESTAMP);
        Date latestSignature = this.getLatestTimestampProductionDate(this.timestamps, TimestampType.SIGNATURE_TIMESTAMP);
        TimestampType[] timestampTypesCoveringValidationData = TimestampType.getTimestampTypesCoveringValidationData();
        Date earliestValidationData = this.getEarliestTimestampProductionTime(this.timestamps, timestampTypesCoveringValidationData);
        Date latestValidationData = this.getLatestTimestampProductionDate(this.timestamps, timestampTypesCoveringValidationData);
        Date earliestArchive = this.getEarliestTimestampProductionTime(this.timestamps, TimestampType.ARCHIVE_TIMESTAMP);
        if (latestContent == null && earliestSignature == null && earliestValidationData == null && earliestArchive == null) {
            return true;
        }
        boolean ok = true;
        if (earliestSignature == null && (earliestValidationData != null || earliestArchive != null)) {
            ok = false;
        }
        if (latestContent != null && earliestSignature != null) {
            boolean bl = ok = ok && !latestContent.after(earliestSignature);
        }
        if (latestSignature != null && earliestValidationData != null) {
            boolean bl = ok = ok && !latestSignature.after(earliestValidationData);
        }
        if (latestSignature != null && earliestArchive != null) {
            boolean bl = ok = ok && !earliestArchive.before(latestSignature);
        }
        if (latestValidationData != null && earliestArchive != null) {
            ok = ok && !earliestArchive.before(latestValidationData);
        }
        return ok;
    }

    private Date getLatestTimestampProductionDate(List<TimestampWrapper> timestamps, TimestampType ... selectedTimestampTypes) {
        Date latestProductionTime = null;
        for (TimestampWrapper timestamp : timestamps) {
            if (!this.isInSelectedTypes(selectedTimestampTypes, timestamp.getType())) continue;
            Date productionTime = timestamp.getProductionTime();
            if (latestProductionTime != null && !latestProductionTime.before(productionTime)) continue;
            latestProductionTime = productionTime;
        }
        return latestProductionTime;
    }

    private Date getEarliestTimestampProductionTime(List<TimestampWrapper> timestamps, TimestampType ... selectedTimestampTypes) {
        Date earliestProductionTime = null;
        for (TimestampWrapper timestamp : timestamps) {
            if (!this.isInSelectedTypes(selectedTimestampTypes, timestamp.getType())) continue;
            Date productionTime = timestamp.getProductionTime();
            if (earliestProductionTime != null && !earliestProductionTime.after(productionTime)) continue;
            earliestProductionTime = productionTime;
        }
        return earliestProductionTime;
    }

    private boolean isInSelectedTypes(TimestampType[] allowedTypes, TimestampType type) {
        for (TimestampType timestampType : allowedTypes) {
            if (!timestampType.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_ASTPTCT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_ASTPTCT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TIMESTAMP_ORDER_FAILURE;
    }
}

