/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class RevocationBasicBuildingBlocksCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final XmlBasicBuildingBlocks revocationBBB;
    private Indication indication;
    private SubIndication subIndication;
    private List<XmlName> errors;

    public RevocationBasicBuildingBlocksCheck(XmlValidationProcessLongTermData result, XmlBasicBuildingBlocks revocationBBB, LevelConstraint constraint) {
        super(result, constraint, revocationBBB.getId());
        this.revocationBBB = revocationBBB;
    }

    @Override
    protected boolean process() {
        XmlConclusion savConclusion;
        XmlConclusion xcvConclusion;
        XmlConclusion cvConclusion;
        XmlConclusion iscConclusion;
        XmlISC isc = this.revocationBBB.getISC();
        if (isc != null && !this.isAllowed(iscConclusion = isc.getConclusion())) {
            this.indication = iscConclusion.getIndication();
            this.subIndication = iscConclusion.getSubIndication();
            this.errors = iscConclusion.getErrors();
            return false;
        }
        XmlCV cv = this.revocationBBB.getCV();
        if (cv != null && !this.isAllowed(cvConclusion = cv.getConclusion())) {
            this.indication = cvConclusion.getIndication();
            this.subIndication = cvConclusion.getSubIndication();
            this.errors = cvConclusion.getErrors();
            return false;
        }
        XmlXCV xcv = this.revocationBBB.getXCV();
        if (xcv != null && !this.isAllowed(xcvConclusion = xcv.getConclusion())) {
            this.indication = xcvConclusion.getIndication();
            this.subIndication = xcvConclusion.getSubIndication();
            this.errors = xcvConclusion.getErrors();
            return false;
        }
        XmlSAV sav = this.revocationBBB.getSAV();
        if (sav != null && !this.isAllowed(savConclusion = sav.getConclusion())) {
            this.indication = savConclusion.getIndication();
            this.subIndication = savConclusion.getSubIndication();
            this.errors = savConclusion.getErrors();
            return false;
        }
        return true;
    }

    private boolean isAllowed(XmlConclusion conclusion) {
        boolean allowed = Indication.PASSED.equals(conclusion.getIndication()) || Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()));
        return allowed;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_RORPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_RORPIIC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.errors;
    }
}

