/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class BestSignatureTimeNotBeforeCertificateIssuanceCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;

    public BestSignatureTimeNotBeforeCertificateIssuanceCheck(XmlValidationProcessLongTermData result, Date bestSignatureTime, CertificateWrapper signingCertificate, LevelConstraint constraint) {
        super(result, constraint);
        this.bestSignatureTime = bestSignatureTime;
        this.signingCertificate = signingCertificate;
    }

    @Override
    protected boolean process() {
        return !this.bestSignatureTime.before(this.signingCertificate.getNotBefore());
    }

    @Override
    protected String getAdditionalInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String bestSignatureTimeStr = this.bestSignatureTime == null ? " ? " : sdf.format(this.bestSignatureTime);
        return MessageFormat.format("Best signature time : {0}", bestSignatureTimeStr);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NOT_YET_VALID;
    }

    @Override
    protected Indication getSuccessIndication() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getSuccessSubIndication() {
        return SubIndication.OUT_OF_BOUNDS_NO_POE;
    }
}

